/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 * 
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)mfTransaction.h 1.11     04/05/19 SMI"
 *
 */


/* File
 * ----
 * mfTransaction.h - MF transaction API standard header file
 *
 * Description
 * -----------
 *
 *                                                                 
 * This header file defines all defines, typedefs, structures,  
 * and API functions visible for an application which use MF
 * 
 * This file contains the exported definitions of the jesma
 * library. This file is the one that should be inculded
 * in applications that intend to use the library
 */

#ifndef MF_TRANSACTION_H_INCLUDED
#define MF_TRANSACTION_H_INCLUDED
#include "mfUtils.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#include <sys/time.h>


/* --------------------------------------------------------------- */
/* --------------- basic typedef section ------------------------- */
/* --------------------------------------------------------------- */

typedef  void * handle_t;

/* --------------------------------------------------------------- */
/* --------------- basic compound section  ------------------------- */
/* --------------------------------------------------------------- */

/* --------------------------------------------------------------- */
/* ---------------------- defines section ------------------------ */
/* --------------------------------------------------------------- */


/* MF transaction status */

#define STATUS_GOOD    0
#define STATUS_ABORTED 1
#define STATUS_FAILED  2
#define STATUS_UNKNOWN 3
#define STATUS_INVALID  4 

/* --------------------------------------------------------------- */
/* ---------------------- Return Codes section --------------------*/
/* --------------------------------------------------------------- */

#define MF_INSTRUM_ERR_BASE 0x2000
#define MF_INSTRUM_SUCCESS 0

#define MF_INSTRUM_ERR_TXN_TYPE_NAME_TOO_LONG (MF_INSTRUM_ERR_BASE - 1)
#define MF_INSTRUM_ERR_MAX_NUM_TXN_TYPES_REACHED (MF_INSTRUM_ERR_BASE - 2)
#define MF_INSTRUM_ERR_INVALID_TRANS_ID (MF_INSTRUM_ERR_BASE - 3)
#define MF_INSTRUM_ERR_INVALID_TRANS_HANDLE (MF_INSTRUM_ERR_BASE - 4)
#define MF_INSTRUM_ERR_CALL_NOT_ALLOWED_IN_THIS_STATE (MF_INSTRUM_ERR_BASE - 5)
#define MF_INSTRUM_ERR_FUNCTION_DEPRECATED_OR_NOT_SUPPORTED (MF_INSTRUM_ERR_BASE - 6)

/* ---------------------------------------------------------------- */
/* ------------------ MF Transaction API section --------------------------- */
/* ---------------------------------------------------------------- */


extern int mfBlockTransaction(/*[in] */ handle_t *transaction_handle);



extern int mfComputeDeltaTime(/*in */ struct timeval *ptr_start, 
				    /*in */ struct timeval *ptr_stop, 
				    /*out */ unsigned long *delta_time_msec) ;

#define MF_MAX_NUM_TXN_TYPES 256
#define MF_MAX_TXN_NAME_LEN 128
int mfRegisterTransaction(/*[in]*/ const char *transaction_name,
				      /*[in]*/ const char *uri,
				      /*[in]*/ const mfTransactionMetrics_t *trans_metrics,
				      /*[out]*/ unsigned short *tran_id); 



int mfReportTransaction(/*[in]*/ const unsigned short trans_id, 
				    /*[in]*/ const int tran_status, 
				    /*[in]*/ unsigned long respTime,
				    /*[in]*/ unsigned long servTime,
				    /*[in]*/ long long stopTime);



#define MF_LAZY_TRANS_ID 1000
int mfStartTransaction(/*[in]*/ const unsigned short trans_id,
				   /*[in] */  handle_t *parent_handle,
				   /*[out]*/ handle_t *trans_handle);



extern int mfStopTransaction(/*[in]*/ const unsigned short trans_id,
				  /*[in]*/ handle_t *transaction_handle,
				  /*[in]*/ const int tran_status); 



extern int mfUnblockTransaction(/*[in] */ handle_t *transaction_handle);


#define MF_MAX_VERSION_STRING_LENGTH 128
int mfTransactionVersion(/*out */ char *mf_version); 
  
void mfSetIsMonitoringEnabledPointer( long long *is_monitoring_enabledp,
                                        unsigned short tran_id );
#if 0
void mfTransactionResetAllMetricsObjectCounters(void);
#endif


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* MF_TRANSACTION_H_INCLUDED */
