/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 * 
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)mfRserver.h 1.6     04/06/18 SMI"
 *
 */



/*
 * mfResource.h - MF standard header file
 *
 * Description
 * -----------
 *
 *                                                                 
 * This header file defines all defines, typedefs, structures,  
 * and API functions visible for an application which use JESMF
 * 
 */

#ifndef MF_RESOURCE_H_INCLUDED
#define MF_RESOURCE_H_INCLUDED

#include "mfConstant.h"


/*
   fix of bugId 5022188
   extern "C" missing in jesmf_com.h and jesmf_utils.

*/



#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



typedef struct {
	int type;
	char *value;
} AttValue;


typedef struct {
	unsigned int String_array_len;
	char **String_array_val;
} String_array;


typedef struct {
	unsigned int  AttValue_array_len;
	AttValue *AttValue_array_val;
} AttValue_array;






/* --------------------------------------------------------------- */
/* --------------- basic compound section  ------------------------*/
/* --------------------------------------------------------------- */

typedef int getterFunc_t (void *handle,
			   char *attributeName,
			   void **value,
			   int *type) ;

typedef int setterFunc_t (void *handle,
			   char *attributeName,
			   void *value) ;

typedef int invokerFunc_t(void *handle, 
			   char* methodName,
			   AttValue_array paramsArray, 
			   String_array signatureArray,
			   void *value,
			   int *type);

typedef struct mfResourceObject {
  getterFunc_t *getter ;                /* callback for gettter function */
  setterFunc_t *setter;                 /* callback for sette function */
  invokerFunc_t *invoker;               /* callback for invoker function */
  void  *resource;                      /* pointer towards resource object */
} mfResourceObject_t ;






/* --------------------------------------------------------------- */
/* ---------------------- defines section ------------------------ */
/* --------------------------------------------------------------- */

#define SIZE_OF_RESOURCE sizeof(resource_object_t)

/* ---------------------------------------------------------------- */
/* ------------------ JESMF API section --------------------------- */
/* ---------------------------------------------------------------- */


int mfCreateResourceServer();
int mfRegisterResource(/*in */ mfResourceObject_t *resourceObject, 
			       /*in */ char *resourceName);
int mfRegisterSimpleResource(/*in*/ void *resourceAddr,
			    /*in */ char *resourceName, 
			    /*in */ char  *attributeName,  
			    /*in */ int type);

int mfUnRegisterResource(/*in */char *resourceName);
int mfUnRegisterSimpleResource(/*in */ char *resourceNname, 
			      /*in */ char *attributeName);

int mfGetResourceAttributePtr(/*in */ char *resourceName,
			     /*in */ char *attributeName, 
			     /*out */ void **value, 
			     /*out*/ int *type);

int mfSetResourceAttribute(/*in */ char *resourceName, 
			  /*in */ char *attributeName, 
			  /*in */ void *value);

int mfInvokeResource(/*in */ char *resourceName, 
		    /*in */  char *methodName, 
		    /*in */ AttValue_array params_array, 
		    /*in */ String_array signature_array, 
		    /*out */ void *value,  
		    /*out*/ int *type);

#ifdef __cplusplus
}
#endif /* __cplusplus */

       
#endif /* JESMF_H_INCLUDED */
