/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 * 
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)mfConstant.h 1.10     04/06/24 SMI"
 *
 */

/*
 * mfConstant.h  - MF standard header file
 * 
 */

#ifndef MF_CONSTANT_H_INCLUDED
#define MF_CONSTANT_H_INCLUDED

#include "mfConstant.h"


#define MF_COM_VERSION "JESMF COM VERSION 0.1" 



          
#define MF_ATTRIBUTE_NAME_SIZE 1024   /* attribute name string length */ 
#define MF_NB_RESOURCE_BUCKETS 500


 /* Attribute tyep constants
 There is a correspondance 1 to 1 with the
   type defined in AttDef.java */

#define MF_TYPE_METHOD_NOT_EXIST -3
#define MF_TYPE_CALLBACK_NOT_EXIST  -2
#define MF_TYPE_ATTRIBUTE_NOT_EXIST  -1
#define MF_TYPE_OBJECT_NOT_EXIST 0
#define MF_TYPE_BOOLEAN 1
#define MF_TYPE_CHAR    2  /* implemented as a byte in java */
#define MF_TYPE_DOUBLE  3
#define MF_TYPE_FLOAT   4
#define MF_TYPE_INT     5
#define MF_TYPE_LONGLONG 6 /* Implemented as long in java */
#define MF_TYPE_SHORT   7
#define MF_TYPE_STRING  8



#define MF_ENABLED (long long)  0x0000000000000001
#define MF_DISABLED (long long) 0x0000000000000000

#define OPS_FAILED     (long) 0x4
#define OPS_RUNNING    (long) 0x1
#define OPS_STARTING   (long) 0x0
#define OPS_STOPPED    (long) 0x3 
#define OPS_STOPPING   (long) 0x2 
    
#define AVAIL_CONGESTED (long) 0x7
#define AVAIL_DEGRADED  (long) 0x6
#define AVAIL_NORMAL    (long) 0x5



/* Return code constants */
#define MF_SUCCESS 0
#define MF_FAILED  -10000
#define MF_EXIST   -10001
#define MF_NOEXIST -10002
#define MF_NOMORE  -10003
#define MF_NULL_PARAM -10004
#define MF_FAILURE -11000


/* EXIST Constants */
#define MF_CONNECTOR_SERVER_EXIST -10005
#define MF_RESOURCE_SERVER_EXIST -10006
#define MF_RESOURCE_OBJECT_EXIST -10007
#define MF_RESOURCE_ATTRIBUTE_EXIST -10015


/*NOTEXIST Constants */
#define MF_RESOURCE_SERVER_NOT_EXIST -10008
#define MF_RESOURCE_OBJECT_NOT_EXIST -10009
#define MF_RESOURCE_ATTRIBUTE_NOT_EXIST -10010
#define MF_RESOURCE_METHOD_NOT_EXIST -10011
#define MF_RESOURCE_GETTER_CALLBACK_NOT_EXIST -10012
#define MF_RESOURCE_SETTER_CALLBACK_NOT_EXIST -10013
#define MF_RESOURCE_INVOKER_CALLBACK_NOT_EXIST -10014
#define MF_RESOURCE_NOT_EXIST -10016


#ifdef DEBUG
#define DEBUG_PRINTF(x) printf(x)
#define DEBUG_PRINTF2(x,y) printf(x,y)
#define DEBUG_PRINTF3(x,y,z) printf(x,y,z)
#define DEBUG_PRINTF4(x,y,z,t) printf(x,y,z,t)
#define DEBUG_PRINTF5(x,y,z,t,u) printf(x,y,z,t,u)
#else
#define DEBUG_PRINTF(x)
#define DEBUG_PRINTF2(x,y)
#define DEBUG_PRINTF3(x,y,z)
#define DEBUG_PRINTF4(x,y,z,t)
#define DEBUG_PRINTF5(x,y,z,t,u)
#endif



#endif

