/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 * 
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)STORE_CLIENT.java 1.3     04/05/19 SMI"
 *
 */

package com.sun.mfwk.examples.storeCP;

import java.rmi.*;

public class STORE_CLIENT {

	private static final String removeType = "REMOVE";
	private static final String modifyType = "MODIFY";
	private static final String searchType = "SEARCH";
	private static final String[] operationTypes = {removeType, modifyType, searchType};
	private static final String USAGE = new String("USAGE : java com.sun.mfwk.examples.storeCP.STORE_CLIENT -t <" + removeType + "|" + modifyType + "|" + searchType + "> -k key [-v value]\n");	
	private String operationType = "";
	private String key = "";
	private String value = "";
	private STORE_SRV storeSrv = null;
	
	private void parseargs(String[] args) {
		if ((args.length > 6) || (args.length < 2)) {
			System.out.println(USAGE);
			System.exit(1);
		}
		int index = 0;
		String type = "";
		while (index < args.length) {
			if (args[index].equals("-t")) {
				if (++index == args.length) {
					System.err.println("Missing operation type\n");
					System.err.println(USAGE);
					System.exit(1);
				}
				type = args[index];
				for (int i=0; i<operationTypes.length; i++) {
					if (type.equals(operationTypes[i])) {
						operationType = type;
					}
				}
				if (operationType.length() == 0) {
					System.err.println("Bad operation type\n");
					System.err.println(USAGE);
					System.exit(1);
				}
			} else if (args[index].equals("-k")) {
				if (++index == args.length) {
					System.err.println("Missing key\n");
					System.err.println(USAGE);
					System.exit(1);
				}
				key = args[index];
			} else if (args[index].equals("-v")) {
				if (++index == args.length) {
					System.err.println("Missing value\n");
					System.err.println(USAGE);
					System.exit(1);
				}
				value = args[index];
			} else {
				System.err.println("Unrecognized option\n");
				System.err.println(USAGE);
				System.exit(1);
			}
			index++;
		}
		if (key.length() == 0) {
				System.err.println("Missing key\n");
				System.err.println(USAGE);
				System.exit(1);
		}
		if (operationType.equals(modifyType)) {
			if (value.length() == 0) {
				System.err.println("Missing value\n");
				System.err.println(USAGE);
				System.exit(1);
			}
			System.out.println("Request : " + operationType + " key=" + key + " value=" + value + "\n");
		} else {
			System.out.println("Request : " + operationType + " key=" + key + "\n");
		}
		if (key.equals("null")) {
			key = null;
		} 
		if (value.equals("null")) {
			value = null;
		}
		
	}

	public void init() {
		try {
			//if (System.getSecurityManager() == null) {
                        //        System.setSecurityManager(new RMISecurityManager());
                        //}
			String storeSrvName = "//localhost/STORE_SRV";
			storeSrv = (STORE_SRV) Naming.lookup(storeSrvName);
		} catch (Exception e) {
			System.err.println("Cannot connect to the STORE_SRV.\n");
			e.printStackTrace();
		}
	}
			
	public void processRequest() {
		try {
			String result = "";
			if (operationType.equals(modifyType)) {
				result = storeSrv.MODIFY(key, value);
			} else if (operationType.equals(searchType)) {
				result = storeSrv.SEARCH(key);
			} else if (operationType.equals(removeType)) {
				result = storeSrv.REMOVE(key);
			}
			System.out.println("Result : " + result + "\n");
		} catch (RemoteException e) {
			System.err.println("A pb occured when calling STORE_SRV\n");
			e.printStackTrace();
		}
	}	
		
	public static void main(String[] args) {
		
		STORE_CLIENT client = new STORE_CLIENT();
		client.parseargs(args);
		client.init();
		client.processRequest();
		System.exit(0);
	}
}





