/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 * 
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)MSG_SRV.java 1.8     04/05/19 SMI"
 *
 */

package com.sun.mfwk.examples.storeCP;

// java imports
//

import java.util.*;
import java.io.*;
import java.net.*;
import java.rmi.*;
import java.util.logging.Logger;

import com.sun.mfwk.util.instrum.*;
import com.sun.mfwk.util.log.*;



public class MSG_SRV {

	MfExternalResourceMetrics monitoring;
	com.sun.mfwk.examples.msgCP.MSG_SRV msgSrv = null;
	Logger logger = MfLogService.getLogger("MSG_SRV");

	private long lastOutboundActivity = -1;
	
       /*
       ** Constructor
       */
       public MSG_SRV() throws IOException {
	       try {
			//if (System.getSecurityManager() == null) {
			//        System.setSecurityManager(new RMISecurityManager());
			//}
			String msgSrvName = "//localhost/MSG_SRV";
			msgSrv = (com.sun.mfwk.examples.msgCP.MSG_SRV) Naming.lookup(msgSrvName);
			msgSrv.LOG("New application instance is logging\n");
		} catch (Exception ie) {
		    logger.severe("Cannot connect to the MSG_SRV : " + ie.getMessage() +"\n" );
		    throw new IOException(ie.getMessage());
		}
       }
       
       
       /*
       ** Setter for ExternalResourceMetrics
       */
       public void setExternalResourceMetrics(MfExternalResourceMetrics m) {
	       this.monitoring = m;
       }
       	

       public void log(String msg) throws IOException {
	       try {
		       long startTime = java.lang.System.currentTimeMillis();
		       
		       msgSrv.LOG(msg);
		       
		       long stopTime = java.lang.System.currentTimeMillis();
		       long queryTime = stopTime - startTime;
		       monitoring.setAccumulatedQueriesTime(monitoring.getAccumulatedQueriesTime() + queryTime);
		       monitoring.setAccumulatedSqQueriesTime(monitoring.getAccumulatedSqQueriesTime() + (queryTime*queryTime));
		       monitoring.setNbQueries(monitoring.getNbQueries() + 1);
		       updateMinMaxQueriesTime(queryTime);
		       
		       monitoring.setOutboundAssociations(monitoring.getOutboundAssociations() + 1);
		       monitoring.setAccumulatedOutboundAssociations(monitoring.getAccumulatedOutboundAssociations() + 1);
		       monitoring.setLastOutboundActivity(lastOutboundActivity);
		       lastOutboundActivity  = java.lang.System.currentTimeMillis();
        	} catch (Exception e) {
			monitoring.setFailedOutboundAssociations(monitoring.getFailedOutboundAssociations() + 1);
			monitoring.setFailedQueries(monitoring.getFailedQueries() + 1);
			throw new IOException(e.getMessage());
		}
    }
    
    private synchronized void updateMinMaxQueriesTime(long value) {
	       
	       long min = monitoring.getMinQueriesTime();
	       long max = monitoring.getMaxQueriesTime();
	       
	       if (min == 0 && max == 0) {
		       monitoring.setMaxQueriesTime(value);
		       monitoring.setMinQueriesTime(value);
	       } else if (value < min) {
		       monitoring.setMinQueriesTime(value);
	       } else if (value > max) {
		       monitoring.setMaxQueriesTime(value);
	       }
       }
}





