/*
 * Copyright (c) 2004
 */

/*
 *  httpd Header File
 */



#ifndef _HTTPD_H

#define _HTTPD_H 1

#ifdef __cplusplus
extern "C" {
#endif



/***********************************************************************
 * Macro Definitions
 */


#define	HTTP_PORT 		80
#define HTTP_MAX_LEN		10240
#define HTTP_MAX_URL		1024
#define HTTP_MAX_HEADERS	1024
#define HTTP_MAX_AUTH		128
#define	HTTP_IP_ADDR_LEN	17
#define	HTTP_TIME_STRING_LEN	40
#define	HTTP_READ_BUF_LEN	4096
#define	HTTP_ANY_ADDR		NULL

#define	HTTP_GET		1
#define	HTTP_POST		2

#define	HTTP_TRUE		1
#define HTTP_FALSE		0

#define	HTTP_FILE		1
#define HTTP_C_FUNCT		2
#define HTTP_EMBER_FUNCT	3
#define HTTP_STATIC		4
#define HTTP_WILDCARD		5
#define HTTP_C_WILDCARD		6

#define HTTP_METHOD_ERROR "\n<B>ERROR : Method Not Implemented</B>\n\n"

#define httpdRequestMethod(s) 		s->request.method
#define httpdRequestPath(s)		s->request.path
#define httpdRequestContentType(s)	s->request.contentType
#define httpdRequestContentLength(s)	s->request.contentLength

#define HTTP_ACL_PERMIT		1
#define HTTP_ACL_DENY		2


/***********************************************************************
 * Type Definitions
 */

typedef	struct _http_req {
    int  method;
    int  contentLength;
    int  authLength;
    char path[HTTP_MAX_URL];
    char userAgent[HTTP_MAX_URL];
    char referer[HTTP_MAX_URL];
    char ifModified[HTTP_MAX_URL];
    char contentType[HTTP_MAX_URL];
    char authUser[HTTP_MAX_AUTH];
    char authPassword[HTTP_MAX_AUTH];
} httpReq;


typedef struct _httpd_var {
    char   *name;
    char   *value;
    struct _httpd_var *nextValue;
    struct _httpd_var *nextVariable;
} httpVar;

typedef struct _httpd_content {
    char   *name;
    int	   type,
           indexFlag;
    void   (*function)();
    char   *data,
           *path;
    int    (*preload)();
    struct _httpd_content *next;
} httpContent;

typedef struct _http_res {
    int         responseLength;
    httpContent *content;
    char        headersSent,
                headers[HTTP_MAX_HEADERS],
                response[HTTP_MAX_URL],
                contentType[HTTP_MAX_URL];
} httpRes;


typedef struct _httpd_dir {
    char   *name;
    struct _httpd_dir *children,
                      *next;
    struct _httpd_content *entries;
} httpDir;


typedef struct ip_acl_s {
    int    addr;
    char   len,
           action;
    struct ip_acl_s *next;
} httpAcl;


typedef struct _httpd {
    int  port,
         serverSock,
         clientSock,
         readBufRemain,
         startTime;
    char clientAddr[HTTP_IP_ADDR_LEN],
         fileBasePath[HTTP_MAX_URL],
         readBuf[HTTP_READ_BUF_LEN + 1],
         *host,
         *readBufPtr;
    httpReq request;
    httpRes response;
    httpVar *variables;
    httpDir *content;
    httpAcl *defaultAcl;
    FILE    *accessLog,
            *errorLog;
} httpd;



/***********************************************************************
 * Function Prototypes
 */


int httpdAddCContent(httpd*, char*, char*, int, int(*)(), void(*)());
int httpdAddFileContent(httpd*, char*, char*, int, int(*)(), char*);
int httpdAddStaticContent(httpd*, char*, char*, int, int(*)(), char*);
int httpdAddWildcardContent(httpd*, char*, int(*)(), char*);
int httpdAddCWildcardContent(httpd*, char*, int(*)(), void(*)());
int httpdAddVariable(httpd*, const char*, const char*);
int httpdGetConnection(httpd*, struct timeval*);
int httpdReadRequest(httpd*);
int httpdCheckAcl(httpd*, httpAcl*);

char *httpdRequestMethodName(httpd*);
char *httpdUrlEncode(char *);

void httpdAddHeader(httpd*, char*);
void httpdSetContentType(httpd*, char*);
void httpdSetResponse(httpd*, char*);
void httpdEndRequest(httpd*);

httpd *httpdCreate(const char *host, int port);
void httpdFreeVariables(httpd*);
void httpdDumpVariables(httpd*);
void httpdOutput(httpd*, char*);
void httpdPrintf(httpd*, char*, ...);
void httpdProcessRequest(httpd*);
void httpdSendHeaders(httpd*);
void httpdSetFileBase(httpd*, char*);
void httpdSetCookie(httpd*, char*, char*);

void httpdSetErrorLog(httpd*, FILE*);
void httpdSetAccessLog(httpd*, FILE*);
void httpdSetDefaultAcl(httpd*, httpAcl*);

httpVar	*httpdGetVariableByName(httpd*, char*);
httpVar	*httpdGetVariableByPrefix(httpd*, char*);
httpVar	*httpdGetVariableByPrefixedName(httpd*, char*, char*);
httpVar *httpdGetNextVariableByPrefix(httpVar*, char*);

httpAcl *httpdAddAcl(httpd*, httpAcl*, char*, int);

int httpdAuthenticate(httpd *server, char *realm);
int httpdForceAuthenticate(httpd *server, char *realm);


#ifdef __cplusplus
	}
#endif /* __cplusplus */

#endif /* #ifndef _HTTPD_H */


