/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 * 
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)MfStatusMBean.java 1.6     04/06/25 SMI"
 *
 */

package com.sun.mfwk.util.instrum;


/**
 * MfStatusMBean contains the status of a component product
 */

public interface  MfStatusMBean {

    // No specific constructor


    // Public constants
    public static final int OPS_FAILED = 4;
    public static final int OPS_RUNNING = 1;
    public static final int OPS_STARTING = 0;
    public static final int OPS_STOPPED = 3;
    public static final int OPS_STOPPING = 2;
    
    public static final int AVAIL_CONGESTED  = 7;
    public static final int AVAIL_DEGRADED = 6;
    public static final int AVAIL_NORMAL = 5;

 
    // Public Instance Methods

    /**
     * Get the availability state.
     */
    public int getAvailabilityState();

    /**
     * Get the availability state last change time.
     * The returned value is the number of milliseconds since January 1, 1970, 00:00:00.
     */
    public long getAvailStateLastChange();

    /**
     * Get the time the component product has entered in a degraded or congested state.
     * The returned value is the number of milliseconds since January 1, 1970, 00:00:00.
     */
    public long getDegradedTime();

    /**
     * Get the operational state.
     */
    public int getOperationalState();

    /**
     * Get the operational state last change time.
     * The returned value is the number of milliseconds since January 1, 1970, 00:00:00.
     */
    public long getOpsStateLastChange();

    /**
     * Get the time the component product has entered in a running state.
     * The returned value is the number of milliseconds since January 1, 1970, 00:00:00.
     */
    public long getRunningTime();

}

