/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 * 
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)MfResourceMetrics.java 1.5     04/06/02 SMI"
 *
 */

package com.sun.mfwk.util.instrum; 

import javax.management.*;
import java.util.logging.*;
import com.sun.mfwk.util.log.MfLogService;

/**
 * MfResourceMetrics contains the generic metrics related to a resource.
 */

public class  MfResourceMetrics extends MfMetric 
    implements MfResourceMetricsMBean {


    //////////////////////////////////////////////////
    //
    // Implementation of ResourceMetricsMBean
    //
    //////////////////////////////////////////////////

    /**
     * Get the number of failed operations.
     */
    public long getFailedOperations() {
	return failedOperations;

    }

    /**
     * Get the number of operations.
     */
    public long getNbOperations() {
	return nbOperations;
    }

    /**
     * Get the minimum operation time since the reference time.
     */
    public long getMinOperationTime() {
	return minOperationTime;
    }

    /**
     * Get the maximum operation time since the reference time.
     */
    public long getMaxOperationTime() {
	return maxOperationTime;
    }

    /**
     * Get the accumulated operation time since the reference time.
     */
    public long getAccumulatedOperationTime() {
	return accumulatedOperationTime;
    }

    /**
     * Get the accumulated squared operation time since the reference time.
     */
    public long getAccumulatedSqOperationTime() {
	return accumulatedSqOperationTime;
    }

    /**
     * Reset all the metrics.
     */
    public synchronized void resetMetrics() {
	logger.entering("MfResourceMetrics", "resetMetrics");	
	failedOperations = 0;
	nbOperations = 0;
	minOperationTime = 0;
	maxOperationTime = 0;
	accumulatedOperationTime = 0;
	accumulatedSqOperationTime = 0;    
    }

    /**
     * Handle specific behaviour when the monitoring is enabled.
     */
    protected void handleMonitoringEnabled() {
	// no specific action
    }

    /**
     * Handle specific behaviour when the monitoring is disabled.
     */
    protected void handleMonitoringDisabled() {
	// no specific action
    }

    //////////////////////////////////////
    //
    // Setters (not exposed to management)
    //
    //////////////////////////////////////

    /**
     * Set the number of failed operations.
     */
    public void setFailedOperations(long p) {
	logger.entering("MfResourceMetrics", "setFailedOperations", new Long(p));	
	failedOperations = p;
    }

    /**
     * Set the number of operations.
     */
    public void setNbOperations(long p) {
	logger.entering("MfResourceMetrics", "setNbOperations", new Long(p));	
	nbOperations = p;
    }

    /**
     * Set the minimum operation time since the reference time.
     */
    public void setMinOperationTime(long p) {
	logger.entering("MfResourceMetrics", "setMinOperationTime", new Long(p));	
	minOperationTime = p;
    }

    /**
     * Set the maximum operation time since the reference time.
     */
    public void setMaxOperationTime(long p) {
	logger.entering("MfResourceMetrics", "setMaxOperationTime", new Long(p));	
	maxOperationTime = p;
    }

    /**
     * Set the accumulated operation time since the reference time.
     */
    public void setAccumulatedOperationTime(long p) {
	logger.entering("MfResourceMetrics", "setAccumulatedOperationTime", new Long(p));	
	accumulatedOperationTime = p;
    }

    /**
     * Set the accumulated squared operation time since the reference time.
     */
    public void setAccumulatedSqOperationTime(long p) {
	logger.entering("MfResourceMetrics", "setAccumulatedSqOperationTime", new Long(p));	
	accumulatedSqOperationTime = p;
    }


    // Private variables
    long failedOperations = 0;
    long nbOperations = 0;
    long minOperationTime = 0;
    long maxOperationTime = 0;
    long accumulatedOperationTime = 0;
    long accumulatedSqOperationTime = 0; 

    private static Logger logger = MfLogService.getLogger("UtilInstrum");   
}
