/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 * 
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)MfObjectNameFactory.java 1.6     04/05/19 SMI"
 *
 */

package com.sun.mfwk.util.instrum;

import javax.management.*;

/**
 * MfObjectNameFactory provides methods to create the transaction API objects.
 */

public class MfObjectNameFactory {

    public static final String DOMAIN = "MfInstrum";
    public static final String TRANS_METRICS_TYPE = "MfTransactionMetrics";
    public static final String STATUS_TYPE = "MfStatus";
    public static final String INSTRUM_MGMT_TYPE = "InstrumentationManagement";
    public static final String INSTRUM_CONFIG_TYPE = "InstrumentationConfiguration";
    public static final String RESOURCE_METRICS_TYPE = "MfResourceMetrics";
    public static final String EXT_RESOURCE_METRICS_TYPE = "MfExternalResourceMetrics";


    // Prevent instanciation
    private MfObjectNameFactory() {
    }

    // Public Instance Methods

    /**
     * Creates a new ObjectName for a MfTransactionMetrics instance.
     *<p>
     *<p>
     *@return ObjectName
     *@param name the related name.
     */
    public static ObjectName getTransactionMetricsName(String name)
    throws MalformedObjectNameException {

	if (name == null)
	    throw new MalformedObjectNameException();

	ObjectName objName = null;
	try {
	    String objNameString = DOMAIN + ":" + "type=" + TRANS_METRICS_TYPE + ",name=" + name;
	    objName = new ObjectName(objNameString);
	} catch (MalformedObjectNameException e) {
	    throw e;
	}

	return objName;
    }
    
    /**
     * Creates a new ObjectName for MfStatus.
     *<p>
     *<p>
     *@return ObjectName
     */
    public static ObjectName getStatusName()
	throws MalformedObjectNameException {

	ObjectName objName = null;
	try {
	    String name = DOMAIN + ":" + "type=" + STATUS_TYPE;
	    objName = new ObjectName(name);
	} catch (MalformedObjectNameException e) {
	    throw e;
	}

	return objName;
    }
    
    /**
     * Creates a new ObjectName for instrumentation management MBean.
     *<p>
     *<p>
     *@return ObjectName
     */
    public static ObjectName getInstrumManagementName()
	throws MalformedObjectNameException {

	ObjectName objName = null;
	try {
	    String name = DOMAIN + ":" + "type=" + INSTRUM_MGMT_TYPE;
	    objName = new ObjectName(name);
	} catch (MalformedObjectNameException e) {
	    throw e;
	}

	return objName;
    }
    
    /**
     * Creates a new ObjectName for instrumentation config MBean.
     *<p>
     *<p>
     *@return ObjectName
     */
    public static ObjectName getInstrumConfigName()
	throws MalformedObjectNameException {

	ObjectName objName = null;
	try {
	    String name = DOMAIN + ":" + "type=" + INSTRUM_CONFIG_TYPE;
	    objName = new ObjectName(name);
	} catch (MalformedObjectNameException e) {
	    throw e;
	}

	return objName;
    }
    
    /**
     * Creates a new ObjectName for resource metrics MBean.
     *<p>
     *<p>
     *@return ObjectName
     *@param name the related name.
     */
    public static ObjectName getResourceMetricsName(String name)
	throws MalformedObjectNameException {

	if (name == null)
	    throw new MalformedObjectNameException();

	ObjectName objName = null;
	try {
	    String objNameString = DOMAIN + ":" + "type=" + RESOURCE_METRICS_TYPE + ",name=" + name;
	    objName = new ObjectName(objNameString);
	} catch (MalformedObjectNameException e) {
	    throw e;
	}

	return objName;
    }
    
    /**
     * Creates a new ObjectName for external resource metrics MBean.
     *<p>
     *<p>
     *@return ObjectName
     *@param name the related name.
     */
    public static ObjectName getExternalResourceMetricsName(String name)
	throws MalformedObjectNameException {

	ObjectName objName = null;
	try {
	    String objNameString = DOMAIN + ":" + "type=" + EXT_RESOURCE_METRICS_TYPE + ",name=" + name;
	    objName = new ObjectName(objNameString);
	} catch (MalformedObjectNameException e) {
	    throw e;
	}

	return objName;
    }
    


   
}


