/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 * 
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)MfInstrumManagementMBean.java 1.6     04/05/19 SMI"
 *
 */

package com.sun.mfwk.util.instrum;

import java.util.logging.*;

/**
 * MfInstrumManagementMBean allows instrumentation management.
 * It provides a mean to enable and disable the instrumentation.
 */


public interface MfInstrumManagementMBean {
    
    // Getters

    /**
     * Check if the monitoring is enabled.
     * If the monitoring is disabled, all the MBeans implementing instrumentation 
     * should be unregistered from the MBeanServer.
     */
    public boolean isMonitoringEnabled();

    /**
     * Get the logging level..
     */
    public Level getLoggingLevel();


    // Setters

    /**
     * Set the logging level..
     */
    public void setLoggingLevel(Level level);



    // Operations

    /**
     * Enables the monitoring.
     * This mean that all the instrumentation will be disabled.
     */
    public void enableMonitoring();


    /**
     * Disables the monitoring.
     * This mean that all the instrumentation will be enabled.
     */
    public void disableMonitoring();
}
