/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 * 
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)MfInstrumConfig.java 1.4     04/05/19 SMI"
 *
 */

package com.sun.mfwk.util.instrum;

import javax.management.*;
import java.util.logging.*;
import com.sun.mfwk.util.log.MfLogService;

/**
 * MfInstrumConfig contains the configuration information related to instrumentation 
 * exposed for management.
 */

public class MfInstrumConfig implements MfInstrumConfigMBean {

    ///////////////////////////////////////
    //
    // Implementation of InstrumConfigMBean
    //
    ///////////////////////////////////////

    /**
     * Get the role of the application.
     */
    public String getAppRole() {
	return appRole; 
    }

    /**
     * Get the URL Description of the application.
     */
    public String getAppURLDescription() {
	return appURLDescription; 
    }

    /**
     * Get the directory DN of the application.
     */
    public String getAppDirectoryDN() {
	return appDirectoryDN; 
    }


    //////////
    //
    // Setters
    //
    //////////

    /**
     * Set the role of the application.
     */
    public void setAppRole(String role) {
	logger.entering("MfInstrumConfig", "setAppRole", role);
        appRole = role; 
    }

    /**
     * Set the URL Description of the application.
     */
    public void setAppURLDescription(String desc) {
	logger.entering("MfInstrumConfig", "setAppURLDescription", desc);
        appURLDescription = desc; 
    }

    /**
     * Set the directory DN of the application.
     */
    public void setAppDirectoryDN(String dn) {
	logger.entering("MfInstrumConfig", "setAppDirectoryDN", dn);
	appDirectoryDN = dn; 
    }

    String appRole;
    String appURLDescription;
    String appDirectoryDN;

    private static Logger logger = MfLogService.getLogger("UtilInstrum");
}
