/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 * 
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)MfExternalResourceMetrics.java 1.6     04/06/02 SMI"
 *
 */

package com.sun.mfwk.util.instrum; 

import javax.management.*;
import java.util.logging.*;
import com.sun.mfwk.util.log.MfLogService;


/**
 * MfExternalResourceMetrics contains the metrics related to an external resource.
 */

public class  MfExternalResourceMetrics extends MfMetric
    implements MfExternalResourceMetricsMBean {


    //////////////////////////////////////////////////
    //
    // Implementation of ExternalResourceMetricsMBean
    //
    //////////////////////////////////////////////////

    /**
     * Get the uri of the external resource.
     */
    public String getProviderUri() {
	return providerUri;
    }
	
    /**
     * Get the total number of associations since the initialization.
     */
    public long getAccumulatedOutboundAssociations() {
	return accumulatedOutboundAssociations;
    }
	
    /**
     * Get the total number of failed associations since the initialization.
     */
    public long getFailedOutboundAssociations() {
	return failedOutboundAssociations;
    }
	
    /**
     * Get the number of failed queries.
     */
    public long getFailedQueries() {
	return failedQueries;
    }

    /**
     * Get the number of queries.
     */
    public long getNbQueries() {
	return nbQueries;
    }
	
    /**
     * Get the value of sysUpTime at the time this application last had an outbound association..
     */
    public long getLastOutboundActivity() {
	return lastOutboundActivity;
    }
	
    /**
     * Get the number of current associations.
     */
    public long getOutboundAssociations() {
	return outboundAssociations;
    }
	
    /**
     * Get the minimum query time.
     */
    public long getMinQueriesTime() {
	return minQueriesTime;
    }
	
    /**
     * Get the maximum query time.
     */
    public long getMaxQueriesTime() {
	return maxQueriesTime;
    }
	
    /**
     * Get the accumulated query time.
     */
    public long getAccumulatedQueriesTime() {
	return accumulatedQueriesTime;
    }
	
    /**
     * Get the accumulated squared query time.
     */
    public long getAccumulatedSqQueriesTime() {
	return accumulatedSqQueriesTime;
    }

	

    /**
     * Reset all the metrics.
     */
    public synchronized void resetMetrics() {
	logger.entering("MfExternalResourceMetrics", "resetMetrics");
	providerUri = null;
	accumulatedOutboundAssociations = 0;
	failedOutboundAssociations = 0;
	failedQueries = 0;
	nbQueries = 0;
	lastOutboundActivity = 0;
	outboundAssociations = 0;
	minQueriesTime = 0;
	maxQueriesTime = 0;
	accumulatedQueriesTime = 0;
	accumulatedSqQueriesTime = 0;
    }


    /**
     * Handle specific behaviour when the monitoring is enabled.
     */
    protected void handleMonitoringEnabled() {
	// no specific action
    }

    /**
     * Handle specific behaviour when the monitoring is disabled.
     */
    protected void handleMonitoringDisabled() {
	// no specific action
    }


    //////////////////////////////////////
    //
    // Setters (not exposed to management)
    //
    //////////////////////////////////////

    /**
     * Set the uri of the external resource.
     */
    public void setProviderUri(String p) {
	logger.entering("MfExternalResourceMetrics", "setProviderUri", p);
	providerUri = p;
    }
	
    /**
     * Set the total number of associations since the initialization.
     */
    public void setAccumulatedOutboundAssociations(long p) {
	logger.entering("MfExternalResourceMetrics", "setAccumulatedOutboundAssociations", new Long(p));
	accumulatedOutboundAssociations = p;
    }
	
    /**
     * Set the total number of failed associations since the initialization.
     */
    public void setFailedOutboundAssociations(long p) {
	logger.entering("MfExternalResourceMetrics", "setFailedOutboundAssociations", new Long(p));
	failedOutboundAssociations = p;
    }
	
    /**
     * Set the number of failed queries.
     */
    public void setFailedQueries(long p) {
	logger.entering("MfExternalResourceMetrics", "setFailedQueries", new Long(p));
	failedQueries = p;
    }

    /**
     * Set the number of queries.
     */
    public void setNbQueries(long p) {
	logger.entering("MfExternalResourceMetrics", "setNbQueries", new Long(p));
	nbQueries = p;
    }
	
    /**
     * Set the value of sysUpTime at the time this application last had an outbound association..
     */
    public void setLastOutboundActivity(long p) {
	logger.entering("MfExternalResourceMetrics", "setLastOutboundActivity", new Long(p));
	lastOutboundActivity = p;
    }
	
    /**
     * Set the number of current associations.
     */
    public void setOutboundAssociations(long p) {
	logger.entering("MfExternalResourceMetrics", "setOutboundAssociations", new Long(p));
	outboundAssociations = p;
    }
	
    /**
     * Set the minimum query time.
     */
    public void setMinQueriesTime(long p) {
	logger.entering("MfExternalResourceMetrics", "setMinQueriesTime", new Long(p));
	minQueriesTime = p;
    }
	
    /**
     * Set the maximum query time.
     */
    public void setMaxQueriesTime(long p) {
	logger.entering("MfExternalResourceMetrics", "setMaxQueriesTime", new Long(p));
	maxQueriesTime = p;
    }
	
    /**
     * Set the accumulated query time.
     */
    public void setAccumulatedQueriesTime(long p) {
	logger.entering("MfExternalResourceMetrics", "setAccumulatedQueriesTime", new Long(p));
	accumulatedQueriesTime = p;
    }
	
    /**
     * Set the accumulated squared query time.
     */
    public void setAccumulatedSqQueriesTime(long p) {
	logger.entering("MfExternalResourceMetrics", "setAccumulatedSqQueriesTime", new Long(p));
	accumulatedSqQueriesTime = p;
    }


    // Private variables
    String providerUri = null;
    long accumulatedOutboundAssociations = 0;
    long failedOutboundAssociations = 0;
    long failedQueries = 0;
    long nbQueries = 0;
    long lastOutboundActivity = 0;
    long outboundAssociations = 0;
    long minQueriesTime = 0;
    long maxQueriesTime = 0;
    long accumulatedQueriesTime = 0;
    long accumulatedSqQueriesTime = 0;

    private static Logger logger = MfLogService.getLogger("UtilInstrum");
}
