/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 * 
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)MfTransactionMetricsMBean.java 1.8     04/07/01 SMI"
 *
 */

package com.sun.mfwk.trans; 

import com.sun.mfwk.util.instrum.*;

/**
 * MfTransactionMetricsMBean contains the computed metrics related to transactions
 * exposed for monitoring purpose.
 */

public interface MfTransactionMetricsMBean extends MfMetricMBean {

    // No specific constructor

    // Public Instance Methods

    /**
     * Get the URI associated to the transaction metrics.
     */
    public String getUri();

    /**
     * Get the number of requests received by this URI.
     */
    public long getNbInRequests();

    /**
     * Get the number of requests responded by this URI.
     */
    public long getNbOutRequests();

    /**
     * Get the number of failed requests for this URI.
     */
    public long getNbFailedRequests();

    /**
     * Get the number of aborted requests for this URI.
     */
    public long getNbAbortedRequests();

    /**
     * Get the maximum response time of this URI since the reference time.
     */
    public long getMaxResponseTime();

    /**
     * Get the minimum response time of this URI since the reference time.
     */
    public long getMinResponseTime() ;

    /**
     * Get the accumulated response time of this URI since the reference time.
     */
    public long getAccumulatedResponseTime();

    /**
     * Get the accumulated squared response time of this URI since the reference time.
     */
    public long getAccumulatedSqResponseTime();

    /**
     * Get the minimum service time of this URI since the reference time.
     */
    public long  getMinServiceTime() ;


    /**
     * Get the maximum service time of this URI since the reference time.
     */
    public long  getMaxServiceTime() ;

    /**
     * Get the accumulated service time of this URI since the reference time.
     */
    public long  getAccumulatedServiceTime();

    /**
     * Get the accumulated squared Service time of this URI since the reference time.
     */
    public long  getAccumulatedSqServiceTime();



    ////////////////////////////////////////////////////////////////
    //
    // Single metrics (does not take into account sub-transactions)
    //
    ////////////////////////////////////////////////////////////////

    /**
     * Get the number of failed requests for this URI.
     * Only used for a parent transaction: this metric does not contain sub-transaction
     * correlated data.
     */
    public long getSingleNbFailedRequests();

    /**
     * Get the number of aborted requests for this URI.
     * Only used for a parent transaction: this metric does not contain sub-transaction
     * correlated data.
     */
    public long getSingleNbAbortedRequests();

    /**
     * Get the minimum service time of this URI since the reference time.
     * Only used for a parent transaction: this metric does not contain sub-transaction
     * correlated data.
     */
    public long  getSingleMinServiceTime() ;


    /**
     * Get the maximum service time of this URI since the reference time.
     * Only used for a parent transaction: this metric does not contain sub-transaction
     * correlated data.
     */
    public long  getSingleMaxServiceTime() ;

    /**
     * Get the accumulated service time of this URI since the reference time.
     * Only used for a parent transaction: this metric does not contain sub-transaction
     * correlated data.
     */
    public long  getSingleAccumulatedServiceTime();

    /**
     * Get the accumulated squared Service time of this URI since the reference time.
     * Only used for a parent transaction: this metric does not contain sub-transaction
     * correlated data.
     */
    public long  getSingleAccumulatedSqServiceTime();

}
