/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 * 
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)MfTransactionDefinitionImpl.java 1.7     04/10/06 SMI"
 *
 */

package com.sun.mfwk.trans; 

import java.util.*;
import java.util.logging.*;
import com.sun.mfwk.util.log.MfLogService;

/**
 * Implementation of the MfTransactionDefinition interface
 */

class MfTransactionDefinitionImpl extends MfTranInterfaceImpl implements MfTransactionDefinition {

    public MfTransactionDefinitionImpl(String pName, String pUri, MfTransactionMetrics metrics) {
	init(pName, pUri, metrics, true);
    }

    public MfTransactionDefinitionImpl(String pName, String pUri, MfTransactionMetrics metrics, boolean hasComputingInfo) {
	init(pName, pUri, metrics, hasComputingInfo);
    }

    public String getName() {
	this.setErrorCode(MfConstants.OK);
	return name; 
    }

    public String getUri() {
	this.setErrorCode(MfConstants.OK);
	return uri; 
    }

    public int getID() {
	// not supported
	return 0; 
    }

    public MfTransactionMetrics getTransactionMetrics() {
	this.setErrorCode(MfConstants.OK);
	return transMetrics; 
    }

    public boolean hasComputingInfo() {
	this.setErrorCode(MfConstants.OK);
	return hasCompInfo;
    }

    private void init(String pName, String pUri, MfTransactionMetrics metrics, boolean hasComputingInfo) {
	if ((pName == null) || (pUri == null) || (metrics == null)) {
	    this.setErrorCode(MfConstants.INVALID_DEFINITION);
	    logger.finest("INVALID_DEFINITION : " +
			  "(pName == null) || (pUri == null) || (metrics == null)");
	    return;
	}
	name = pName;
	uri = pUri;
	transMetrics = metrics;
	transMetrics.setUri(uri);
	hasCompInfo = hasComputingInfo;
    }

    private String name = null;
    private String uri = null;
    private MfTransactionMetrics transMetrics = null;
    private boolean hasCompInfo = true;

    private static Logger logger = MfLogService.getLogger("MfTransaction"); 
}
