/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 * 
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)MfTranReport.java 1.5     04/06/07 SMI"
 *
 */

package com.sun.mfwk.trans; 

/**
 * MfTranReport defines a transaction instance (report mode).
 * It is created with the newTranReport() method of MfTransactionFactory.
 */


public interface MfTranReport extends MfGenericTransaction, MfTranInterface {

  // No Public Constructors

  // Public Instance Methods 

    /**
     * Report statistics of the transaction, once it is completed.
     *<p>
     *<p>
     *@param status the status of the transaction (one of the constants in MfConstants)
     *@param respTime response time in milliseconds
     *@param servTime service time in milliseconds
     *@param stopTime stop time in milliseconds since January 1, 1970 (same format returned by java.lang.System.currentTimeMillis()
     */
    public int report(int status, long respTime, long servTime, long stopTime);

}
