/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 * 
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)MfTranInterfaceImpl.java 1.9     04/06/04 SMI"
 *
 */

package com.sun.mfwk.trans; 

import java.util.logging.*;
import com.sun.mfwk.util.log.MfLogService;

/**
 * Manages errors for transaction classes.
 */

public abstract class MfTranInterfaceImpl implements MfTranInterface {

    public int getErrorCode() {
	return errorCode;
    }

    public void setErrorCode(int code) {
	if (code != MfConstants.OK)
	    logger.fine("MfTranInterfaceImpl->setErrorCode() called with error code = " + code);
	errorCode = code;
    }

    public String getErrorMessage(int code) {
	if (code == MfConstants.INVALID_TRANSITION)
	    return new String("Invalid transition for this transaction");
	else if (code == MfConstants.INVALID_DEFINITION)
	    return new String("Invalid transaction definition");
	else if (code == MfConstants.MONITORING_DISABLED)
	    return new String("The monitoring is disabled for this transaction definition");
	else if (code == MfConstants.INVALID_CALLER_THREAD)
	    return new String("The caller thread id should be the one that started the transaction");
	else if (code == MfConstants.OK)
	    return new String("No error");
	else
	    return new String("Indeterminate error message (id =" + code + ")");
    }
     
    protected  Logger getLogger() {
	return logger;
    }

    private int errorCode = 0;

    private static Logger logger = MfLogService.getLogger("MfTransaction");
}
