/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 * 
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)MfTranInterface.java 1.4     04/06/02 SMI"
 *
 */

package com.sun.mfwk.trans; 

/**
 * Manages errors for transaction classes.
 *
 */

public interface MfTranInterface {

    // No Public Constructors

    // Public Instance Methods
    
    /**
     * Returns the error code.
     * The error code may change any time a method of the object is executed.
     */
    public int getErrorCode();

    /**
     * Set the error code.
     *<p>
     *<p>
     *@param errorCode the error code
     */
    public void setErrorCode(int errorCode);


    /**
     * Returns a string message describing the error.
     * If the errorCode is not valid, it returns null.
     *<p>
     *<p>
     *@param errorCode the error code
     */
    public String getErrorMessage(int errorCode);

}
