/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 * 
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)MfConstants.java 1.6     04/06/04 SMI"
 *
 */

package com.sun.mfwk.trans; 

/**
 * MfConstants defines constants that are widely used in the monitoring interfaces.
 */

public interface MfConstants {

    // No Public Constructors

    // Constants


    ////////////////////////////
    //
    //  Error codes
    //
    ////////////////////////////

    /**
     * Invalid transition for this transaction
     */
    public static final int INVALID_TRANSITION = 1;

    /**
     * Invalid transaction definition
     */
    public static final int INVALID_DEFINITION = 2;

    /**
     * Invalid transaction definition
     */
    public static final int MONITORING_DISABLED = 3;

    /**
     * Invalid caller thread
     */
    public static final int INVALID_CALLER_THREAD = 4;

    // See OK variable below for no error


    ////////////////////////////
    //
    //  Return codes
    //
    ////////////////////////////

    /**
     * Return code or error code OK
     */
    public static final int OK = 0;


    /**
     * Error return code 
     */
    public static final int NOT_OK = -1;



    ////////////////////////////
    //
    // MfTransaction status
    //
    ////////////////////////////

    /**
     * Valid status value for MfTranReport and MfTransaction (=0)
     */
    public static final int STATUS_GOOD = 0;

    /**
     * Valid status value for MfTranReport and MfTransaction (=1)
     */
    public static final int STATUS_ABORT = 1;

    /**
     * Valid status value for MfTranReport and MfTransaction (=2)
     */
    public static final int STATUS_FAILED = 2;

    /**
     * Valid status value for MfTranReport and MfTransaction (=3)
     */
    public static final int STATUS_UNKNOWN = 3;

    /**
     * MfStatus value used when application passes an invalid value (=-1)
     */
    public static final int STATUS_INVALID = -1;

    // No Instance Methods 
}
