/*
 * MfRandom.java
 *
 * Created on August 2, 2004, 10:40 AM
 */

package com.sun.mfwk.security.genkey;

import java.security.SecureRandom;
import java.math.BigInteger;

/** Class to generate a random seed to pass to the certutil command through 
 *  the -z flag.
 *  This is a main class which takes the seed size as unique parameter.
 *  If not specified, the seed size is 128.
 */

public class MfRandom {

    public static void main(String[] args) {

        int seedSize = 128;

        if ( (args != null) && (args.length >=1) ) {
            // try to convert first arg into an integer
            try {
                seedSize = Integer.parseInt(args[0]);
            }
            catch(Exception e) {
                System.out.println("wrong numeric argument " + args[0]);
                System.exit(1);
            }
        }
    /* This call typically takes some time! */

    byte[] bytes = SecureRandom.getSeed(seedSize);

    BigInteger intVal = new BigInteger(bytes).abs();

    /* output a printable string representation of this random sequence
     * using the maximum available radix (36)
     * XXX we are losing bits here and could roll our own base 95
     */
    System.out.println(intVal.toString(Character.MAX_RADIX));

    } 
}
