/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 * 
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)MfDiscoveryServiceMBean.java 1.6     04/06/29 SMI"
 *
 */


package com.sun.mfwk.discovery;



/**
 * This is the management interface explicitly defined for the "MfDiscoveryServiceMBean" standard MBean.
 * The "MfDiscoveryServiceMBean" standard MBean implements this interface 
 * in order to be manageable through a JMX agent.
 *
 * The "SimpleStandardMBean" interface shows how to expose for management:
 * - read-only attributes ("Port", "Group") through their getter methods
 */

public interface MfDiscoveryServiceMBean {

    /**
     * Getter: get the "Port" value of the multicast channel
     *
     * @return the current value of the "Port" attribute.
     */
 
    public int getMulticastPort();
    
     /**
     * Getter: get the "Group" value of the multicast channel
     *
     * @return the current value of the "Group" attribute.
     */
    
    public String getMulticastGroup();

    public String getVersion();
 
}
