/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 * 
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)CIBStatistic.java 1.12     04/06/17 SMI"
 *
 */

package com.sun.mfwk.cib.statistics;

import javax.management.j2ee.statistics.Statistic;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;

/**
 * Provides methods that should be implemented by a CIBStatistic object
 *  A Statistic interface provides the methods :
 * getName, getUnit, getDescription, getStartTime, getLastSampleTime
 */
public interface CIBStatistic
    extends Statistic {

  /**
   * Returns a CompositeData object based on the Statistic object
   * @throws OpenDataException
   * @return CompositeData
   */
  public CompositeData toCompositeData() throws OpenDataException;

  /**
   * Returns a CIBStatistic object based on the composite data
   * @return CIBStatistic
   */
  public CIBStatistic fromCompositeData(CompositeData data);

}
