/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 *
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)CIBServicePerfStats.java 1.15     04/07/15 SMI"
 *
 */

package com.sun.mfwk.cib.statistics;

import com.sun.mfwk.cib.statistics.CIBTimeStatistic;
import com.sun.mfwk.cib.statistics.CIBRangeStatistic;
import com.sun.mfwk.cib.statistics.CIBCountStatistic;

import com.sun.mfwk.cib.CIBIOException;
import com.sun.mfwk.cib.CIBAttributeNotFoundException;

/**
 * Provides methods that should be implemented by a CIBServicePerfStats provider
 * providing performance statistics for a CIBService
 */

public interface CIBServicePerfStats
    extends CIBPerfStats {

  /**
   * Returns a CIBTimeStatistic with the Resident Time data. Resident Time is defined as the
   * time elapsed between the arrival of a request until the moment the Component Product
   * decides that the request has been serviced.<p>
   * The CIBTimeStatistic interface includes attributes to represent the accumulated value, the
   * accumulated squared values, the minimum and maximum values that were reached since
   * monitoring has been turned on.
   * @throws CIBIOException
   * @throws CIBAttributeNotFoundException
   * @return CIBTimeStatistic
   */
  public CIBTimeStatistic getResidentTime() throws CIBIOException,
      CIBAttributeNotFoundException;

  /**
   * Returns a CIBTimeStatistic representing the Service Time data. Service Time is defined as
   * the <B>CPU time</B> consumption that has been dedicated to service requests.<p>
   * This is needed for statistical performance measurements.
   * @throws CIBIOException
   * @throws CIBAttributeNotFoundException
   * @return CIBTimeStatistic
   */
  public CIBTimeStatistic getServiceTime() throws CIBIOException,
      CIBAttributeNotFoundException;

  /**
   * Returns a CIBValueStatistic representing the number of failed requests (requests with
   * a failed status).
   * @throws CIBIOException
   * @throws CIBAttributeNotFoundException
   * @return CIBCountStatistic
   */
  public CIBCountStatistic getFailedRequests() throws CIBIOException,
      CIBAttributeNotFoundException;

  /**
   * Returns a CIBRangeStatistic representing the OutstandingRequests statistics.
   * @throws CIBIOException
   * @throws CIBAttributeNotFoundException
   * @return CIBRangeStatistic
   */
  public CIBRangeStatistic getOutstandingRequests() throws CIBIOException,
      CIBAttributeNotFoundException;

  /**
   * Returns a CIBCountStatistic representing the number of requests arrived at the Component
   * Product.
   * @throws CIBIOException
   * @throws CIBAttributeNotFoundException
   * @return CIBCountStatistic
   */
  public CIBCountStatistic getInRequests() throws CIBIOException,
      CIBAttributeNotFoundException;

  /** Returns a CIBCountStatistic representing the number of requests completed by the
   * Component Product.
   * @throws CIBIOException
   * @throws CIBAttributeNotFoundException
   * @return CIBCountStatistic
   */
  public CIBCountStatistic getOutRequests() throws CIBIOException,
      CIBAttributeNotFoundException;

}
