/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 * 
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)CIBResourcePerfStats.java 1.12     04/06/17 SMI"
 *
 */

package com.sun.mfwk.cib.statistics;

import com.sun.mfwk.cib.CIBIOException;
import com.sun.mfwk.cib.CIBAttributeNotFoundException;

/**
 * Provides methods that should be implemented by a CIBResourcePerfStats provider
 * providing performance data for a CIBResource
 */
public interface CIBResourcePerfStats
    extends CIBPerfStats {

  /**
   * Return statistic object containing values regarding the Operation Time
   * @throws CIBIOException
   * @throws CIBAttributeNotFoundException
   * @return CIBTimeStatistic
   */
  public CIBTimeStatistic getOperationTime() throws CIBIOException,
      CIBAttributeNotFoundException;

  /**
   * Return a statistic object containing the number of failed operations
   * @throws CIBIOException
   * @throws CIBAttributeNotFoundException
   * @return CIBValueStatistic
   */
  public CIBValueStatistic getFailedOperations() throws CIBIOException,
      CIBAttributeNotFoundException;

}
