/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 *
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)CIBPerfStatsImpl.java 1.12     04/07/15 SMI"
 *
 */

package com.sun.mfwk.cib.sdk.statistics;

// jdk
import java.util.Map;
import java.util.Set;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Logger;

// cib
import com.sun.mfwk.cib.statistics.CIBStats;
import com.sun.mfwk.cib.CIBException;
import com.sun.mfwk.cib.CIBIOException;

// J2ee
import javax.management.j2ee.statistics.Statistic;

// Java ES-MF sdk
import com.sun.mfwk.util.log.MfLogService;

/**
 * Provides default implementation of a CIBPerfStats provider
 */
public abstract class CIBPerfStatsImpl
    implements CIBStats {

  static final Logger logger = MfLogService.getLogger("cib-sdk");
  static final String className = "CIBPerfStatsImpl";

  protected Map statisticsTable;

  /**
   * Returns the Statistic names supported by the Stats object
   * @return String[]
   */
  public String[] getStatisticNames() {
    logger.entering(className, "getStatisticNames");
    Set set = statisticsTable.keySet();
    logger.exiting(className, "getStatisticNames",
                   (String[]) (set.toArray(new String[set.size()])));
    return (String[]) (set.toArray(new String[set.size()]));
  }

  /**
   * Returns the Statistic based on its name
   * @param name String
   * @return Statistic
   */
  public Statistic getStatistic(String name) {
    logger.entering(className, "getStatistic", name);
    logger.exiting(className, "getStatistic",
                   (Statistic) statisticsTable.get(name));
    return (Statistic) statisticsTable.get(name);
  }

  /**
   * Returns the all the statistic objects of the Stats object
   * @return Statistic[]
   */
  public Statistic[] getStatistics() {
    logger.entering(className, "getStatistics");
    Collection collectAppl = statisticsTable.values();
    Statistic[] statistics = new Statistic[collectAppl.size()];
    Statistic elem = null;
    int i = 0;
    for (Iterator j = collectAppl.iterator(); j.hasNext(); ) {
      elem = (Statistic) j.next();
      statistics[i] = elem;
      i++;
    }
    logger.exiting(className, "getStatistics", statistics);
    return statistics;
  }

  /**
   * Initialize and reset the statistic objects of the stats
   */
  public void init() throws CIBIOException, CIBException {
    logger.entering(className, "init");
    Statistic[] statistics = getStatistics();
    for (int i = 0; i < statistics.length; i++) {
      ( (CIBStatisticImpl) statistics[i]).reset();
    }
    logger.exiting(className, "init");
  }

  /**
   * Reset the statictics object of the stats
   */
  public void destroy()  throws CIBIOException, CIBException {
    logger.entering(className, "destroy");
    Statistic[] statistics = getStatistics();
    for (int i = 0; i < statistics.length; i++) {
      ( (CIBStatisticImpl) statistics[i]).reset();
    }
    logger.exiting(className, "destroy");
  }
}
