/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 *
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)CIBApplicationConfiguration.java 1.5     04/06/29 SMI"
 *
 */

package com.sun.mfwk.cib.config;

//cib
import com.sun.mfwk.cib.CIBIOException;
import com.sun.mfwk.cib.CIBAttributeNotFoundException;

/**
 * Provides interfaces that should be implemented by each provider providing
 * CIB Application configuration attributes.
 * The attributes that should be exposed are : UrlDescription, Role and DirectoryDN
 */
public interface CIBApplicationConfiguration
    extends CIBConfiguration {

  /**
   * Get the Url Description document
   * @throws CIBIOException
   * @throws CIBAttributeNotFoundException
   * @return String
   */
  public String getUrlDescription() throws CIBIOException,
      CIBAttributeNotFoundException;

  /**
   * Get the role of the application
   * @throws CIBIOException
   * @throws CIBAttributeNotFoundException
   * @return String
   */
  public String getRole() throws CIBIOException, CIBAttributeNotFoundException;

  /**
   * Get the directory Distinguish Name
   * @return String
   * @throws CIBIOException
   * @throws CIBAttributeNotFoundException
   * @return String
   */
  public String getDirectoryDN() throws CIBIOException,
      CIBAttributeNotFoundException;

}
