/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 * 
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)CIBProviderNotFoundException.java 1.8     04/07/15 SMI"
 *
 */

package com.sun.mfwk.cib;

/**
 * Throws when a provider is not found
 */
public class CIBProviderNotFoundException
    extends CIBException {

  /**
   * Contructs a new CIBProviderNotFoundException
   * @param providerClassName String
   */
  public CIBProviderNotFoundException(String providerClassName) {
    super(providerClassName);
  }

  /**
   * Contructs a new CIBProviderNotFoundException with the detailed message
   * @param message String
   * @param providerClassName String
   */
  public CIBProviderNotFoundException(String message, String providerClassName) {
    super(providerClassName + "-" + message);
  }

  /**
   * Constructs a new CIBProviderNotFoundException with the detailed message and the nested throwable
   * @param providerClassName String
   * @param cause Throwable
   */
  public CIBProviderNotFoundException(String providerClassName, Throwable cause) {
    super(providerClassName, cause);
  }

  /**
   * Constructs a new CIBProviderNotFoundException with the detailed message and the nested throwable
   * @param message String
   * @param providerClassName String
   * @param cause Throwable
   */
  public CIBProviderNotFoundException(String message, String providerClassName,
                                      Throwable cause) {
    super(providerClassName + "-" + message, cause);
  }
}
