/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 * 
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)CIBProductMBean.java 1.15     04/07/15 SMI"
 *
 */

package com.sun.mfwk.cib;

import javax.management.ObjectName;
import javax.management.InvalidAttributeValueException;

/**
 * Provides methods that should be implemented by a CIBProduct managed object.
 * CIBProduct is the base object model to represent a deployed Java-ES Component Product
 * on a particular system.
 * The attributes of the CIBProduct object model specify static identification and
 * configuration data relative to the install of the Component Product.
 */
public interface CIBProductMBean
    extends CIBObjectMBean {

  /**
   * Represents the default vendor name
   */
  public static final String defaultVendor = "Sun Microsystems";

  /**
   * Returns the product name
   * @return String
   */
  public String getProductName() throws InvalidAttributeValueException;

  /**
   * Provides the product version
   * @return String
   */
  public String getProductVersion() throws InvalidAttributeValueException;

  /**
   * Returns the PatchID String which represents the path revision applied
   * to the Componet product
   * @return String
   */
  public String getPatchId();

  /**
   * Returns as a String the Vendor name.
   * @return String
   */
  public String getVendorName() throws InvalidAttributeValueException;

  /**
   * Returns the installation time of the component product
   * @return long
   */
  public long getInstallTime();

  /**
   * Returns the list of ObjectName(s) of each Application instances running
   * into the Product
   * @return ObjectName[]
   */
  public ObjectName[] getApplications();

  /**
   * Returns the ObjectName for a given application
   * @param name String
   * @return ObjectName
   */
  public ObjectName getApplicationByName(String name);

}



