/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 * 
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)CIBObjectMBean.java 1.17     04/08/06 SMI"
 *
 */

package com.sun.mfwk.cib;

import javax.management.ObjectName;
import javax.management.InvalidAttributeValueException;

/**
 * The CIBObjectMBean specifies the management interface of each Object of the
 * Jes common monitoring information base as described into the common
 * information model.
 * The CIBObject is the root object model for all managed objects created in the
 * Common Monitoring Framework.
 * It is used primarily to identify the version of the CIB in the implementing object classes.
 */
public interface CIBObjectMBean {

  /**
   * Represents the Sun Java-ES Monitoring Model Version
   */
  public static String ModelVersion =
      "Sun Java-ES Common Monitoring Schema 1.0";

  /**
   * Returns the name value of the CIBObject Managed Object
   * representing the name=value of the ObjectName
   */
  public String getName() throws InvalidAttributeValueException;

  /**
   * Returns a the type value of the CIBObject managed object representing the
   * the 'type=value' keyproperty found in the ObjectName of the corresponding
   * mbean
   */
  public String getType() throws InvalidAttributeValueException;

  /**
   * Returns the Jes Common monitoring schema version
   */
  public String getModelVersion();

} // end CIBObjectMBean
