/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 *
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)CIBMonitoredObjectMBean.java 1.20     04/07/15 SMI"
 *
 */

package com.sun.mfwk.cib;

import javax.management.openmbean.CompositeData;
import javax.management.j2ee.statistics.Stats;

/**
 * Provides methods that should be implemented by each CIBMonitoredObject managed object
 * to expose its management attributes
 */
public interface CIBMonitoredObjectMBean
    extends CIBManagedObjectMBean {

  /**
   * Returns true, indicates that this managed object implements the State model and is
   * state manageable as described in "StateManagement" chapter of this specification.
   * Returns false, the managed object does not support state model.
   */

  public boolean isStateProvider();

  /**
   * Returns true, indicates that the managed object supports the generation of performance
   * statistics and implements the StatisticsProvider model as described in the
   * "StatisticsProvider" chapter of this specification.
   * Returns false, the managed object does not support performance statistics.
   */

  public boolean isStatisticProvider();

  /**
   * enables/disable the generation of performance
   * statistics data in the supplier application.
   * This operation has no effect if the statisticsProvider attribute is false.
   */
  public void setStateProvider(boolean val) throws CIBException;

  /**
   * disables the generation of performance statistics
   * data in the supplier application. The effect of invoking that operation should
   * be a near zero data generation overhead in the supplier application.
   * This operation has no effect if the statisticsProvider attribute is false.
   * @param val boolean
   */
  public void setStatisticProvider(boolean val) throws CIBException;

  /**
   * Gets a CIB Statistic as a standard serializable JMX Open Type
   * @param name String
   * @throws CIBAttributeNotFoundException
   * @throws CIBException
   * @return CompositeData
   */
  CompositeData getOpenStatistic(String name) throws CIBAttributeNotFoundException, CIBException;

  /**
   * Gets a CIBStats object encoded as a standard serializable JMX Open Type
   * @return CompositeData
   */
  CompositeData getOpenStats() throws CIBException;

  /**
   * Gets all available statistic names
   *
   * @return String[]
   */
  String[] getStatisticNames() throws CIBException;

  /**
   * Gets a CIBStats object for all available statistics.
   *
   * @return Stats
   */
  Stats getStats() throws CIBException;

  /**
   *  Gets all CIBStatistics encoded as serializable JMX Open Types.
   *  If no statistics is found null is returned.
   *
   * @param names String[]
   * @return CompositeData[]
   */
  CompositeData[] getOpenStatistics(String[] names) throws CIBException;

  /**
   * Get the Operational MfStatus of the monitored object
   * @return int
   */
  public int getOperationalStatusState() throws CIBException, CIBAttributeNotFoundException;

  /**
   * Get the time when the operational status last changed
   * @return long
   */
  public long getOperationalStatusLastChange() throws CIBException, CIBAttributeNotFoundException;

  /**
   * Get the time when the Operational status entered into the running state
   * @return long
   */

  public long getOperationalStatusStartTime() throws CIBException, CIBAttributeNotFoundException;

  /**
   * Get the Availability State of the Monitored object
   * @return int
   */
  public int getAvailabilityStatusState() throws CIBException, CIBAttributeNotFoundException;

  /**
   * Get the time when the availability status last changed
   * @return long
   */
  public long getAvailabilityStatusLastChange() throws CIBException, CIBAttributeNotFoundException;

  /**
   * Returns the time the first time the object entered into the degraded state
   * @return long
   */

  public long getAvailabilityStatusDegradedTime() throws CIBException, CIBAttributeNotFoundException;

}
