/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 * 
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits r?serv?s.
 * Ce logiciel est propri?t? de Sun Microsystems, Inc.
 * Distribu? par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)CIBManagedObject.java 1.25     04/07/15 SMI"
 *
 */

package com.sun.mfwk.cib;

import com.sun.mfwk.cib.CIBManagedObjectMBean;
import com.sun.mfwk.cib.CIBObject;
import javax.management.ObjectName;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.NotificationFilter;
import javax.management.MBeanNotificationInfo;
import javax.management.ListenerNotFoundException;
import javax.management.InvalidAttributeValueException;

/**
 * Default implementation of a CIB Managed Object MBean.
 */
public abstract class CIBManagedObject
    extends CIBObject
    implements CIBManagedObjectIf, CIBManagedObjectMBean, NotificationEmitter {

  protected String myDescription = "";
  private ObjectName myJ2eeSibling = null;

  // state for sending events to clients
  protected boolean eventProviderFlag = false;
  protected NotificationBroadcasterSupport eventBroadcaster = new NotificationBroadcasterSupport();

  public CIBManagedObject() {
  }

  /**
   * Returns a description for the Managed object
   * @return String
   */
  public String getDescription(){
    return myDescription;
  }

  /**
   * Sets the description of the managed Object
   * @param description String
   */
  public void setDescription(String description) {
    myDescription=description;
  }

  /**
   * Returns true if the managed object is an Event Provider else returns false
   * @return boolean
   */
  public boolean isEventProvider() {
    return eventProviderFlag;
  }

  /**
   * Allows to switch On/Off the JMX event notifications from the managed object
   * Not implemented in this version the event provision switch is not activated inside
   *  this implementation.
   * @param isEventProvider boolean
   */
  public void setEventProvider(boolean isEventProvider) {
    if (isEventProvider != eventProviderFlag) {
      if (!isEventProvider) {
        eventProviderFlag = false;
      }
      else {
        eventProviderFlag = true;
      }
    }
 }

  /**
   * Allows to set the reference to the J2ee application
   * @param j2eeSibling ObjectName
   */
  public void setJ2eeSibling(ObjectName j2eeSibling){
    myJ2eeSibling = j2eeSibling;
 }

  /**
   * Returns the ObjectName of J2eeApplication possibly attached
   * @return javax.management.ObjectName
   */
  public ObjectName getJ2eeSibling() {
    return myJ2eeSibling;
  }

  /**
   * removeNotificationListener
   *
   * @param notificationListener NotificationListener
   * @param notificationFilter NotificationFilter
   * @param object Object
   */
  public void removeNotificationListener(NotificationListener
                                         notificationListener,
                                         NotificationFilter notificationFilter,
                                         Object object) throws ListenerNotFoundException{
    // delegates to ref broadcaster
    eventBroadcaster.removeNotificationListener(notificationListener,
                                                notificationFilter,
                                                object);

  }

  /**
   * addNotificationListener
   *
   * @param notificationListener NotificationListener
   * @param notificationFilter NotificationFilter
   * @param object Object
   */
  public void addNotificationListener(NotificationListener notificationListener,
                                      NotificationFilter notificationFilter,
                                      Object object) {
    // delegates to ref broadcaster
    eventBroadcaster.addNotificationListener(notificationListener,
                                             notificationFilter,
                                             object);
  }

  /**
   * removeNotificationListener
   *
   * @param notificationListener NotificationListener
   */
  public void removeNotificationListener(NotificationListener
                                         notificationListener) throws ListenerNotFoundException{
    // delegates to ref broadcaster
    eventBroadcaster.removeNotificationListener(notificationListener);
  }

  /**
   * getNotificationInfo
   *
   * @return MBeanNotificationInfo[]
   */
  public MBeanNotificationInfo[] getNotificationInfo() {
    return eventBroadcaster.getNotificationInfo();
  }
}
