/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 * 
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)CIBException.java 1.9     04/07/15 SMI"
 *
 */

package com.sun.mfwk.cib;

/**
 * Root model for the CIB Exception
 */
public class CIBException extends Exception {

  /**
   * Contructs a new CIBException
   */
   public CIBException() {
     super();
   }

   /**
   * Contructs a new CIBException with the detailed message
   * @param message String
   */
   public CIBException(String message) {
     super(message);
   }

   /**
    * Constructs a new CIBException with the detailed message and the nested throwable
    * @param message String
    * @param cause Throwable
    */
   public CIBException(String message, Throwable cause) {
     super(message, cause);
   }

   /**
    * Contructs a new CIBException with a nested trowable
    * @param cause Throwable
    */
   public CIBException(Throwable cause) {
    super(cause);
  }


}
