/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 *
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)CIBApplicationMBean.java 1.19     04/07/15 SMI"
 *
 */

package com.sun.mfwk.cib;

import javax.management.ObjectName;
import javax.management.InvalidAttributeValueException;

/**
 * Provides methods that should be implemented by a CIBApplication managed object
 * to expose its management attributes.
 * The CIBApplication is the base object model to represent a single
 * Java-ES application instance running on a system.
 */
public interface CIBApplicationMBean
    extends CIBMonitoredObjectMBean {

  /**
   * Provides the application URL Description
   * @return String
   */
  public String getApplicationURLDescription() throws InvalidAttributeValueException;

  /**
   * Returns the directory path where static information about this application is stored
   * @return String
   */
  public String getDirectoryDN() throws InvalidAttributeValueException;

  /**
   * Returns the CIBProduct object name
   * @throws InvalidAttributeValueException
   * @return ObjectName
   */
  public ObjectName getProduct() throws InvalidAttributeValueException;

  /**
   * Returns the list of CIBService object names
   * @return ObjectName[]
   */
  public ObjectName[] getServices();

  /**
   * Provides the role of an application instance in the JES environment.
   * @return String
   */
  public String getRole();

  /**
   * Returns the object name of the Service identified by its Uri
   * @param uri String
   * @return ObjectName
   */
  public ObjectName getServiceByUri(String uri) throws CIBException;

  /**
   * Returns the Object Name of the service identified by its name
   * @param name String
   * @return ObjectName
   */
  public ObjectName getServiceByName(String name) throws CIBException;

  /**
   * Returns the list of object names of all the resource associated
   * to the application
   * @return ObjectName[]
   */
  public ObjectName[] getResources();

  /**
   * Returns the Object Name of a resource identified by its uri
   * @param name String
   * @return ObjectName
   */
  public ObjectName getResourceByName(String name) throws CIBException;

  /**
   * Returns the list of External resource object names associated to the application
   * @return ObjectName[]
   */
  public ObjectName[] getExternalResources();

  /**
   * Returns the object name of a ExternalResource associated to the application
   * identifies by its Uri
   * @param uri String
   * @return ObjectName
   */
  public ObjectName getExternalResourceByUri(String uri) throws CIBException;

  /**
   * Returns the object name of the application container
   * @return ObjectName
   */
  public ObjectName getContainer();

  /**
    * Returns the object name of the application container
    * @return ObjectName
    */
   public ObjectName[] getApplicationsSet();

}








