/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 *
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)CIBApplicationIf.java 1.18     04/07/15 SMI"
 *
 */

package com.sun.mfwk.cib;

import javax.management.ObjectName;

/**
 * Provides methods that should be implemented by a CIBApplication managed object
 */
public interface CIBApplicationIf
    extends CIBMonitoredObjectIf {

  /**
   * Allows to add a CIBApplication objectName in the list of ContainedApplications
   * @param objectName ObjectName
   */
  public void addCIBApplication(ObjectName objectName);

  /**
   * Allows to remove a CIBApplication object name from the list of ContainedApplications
   * @param objectName ObjectName
   * @throws CIBException
   */
  public void removeCIBApplication(ObjectName objectName) throws CIBException;

  /**
   * Allows to add a CIBService objectName in the list of DeployedServices
   * @param objectName ObjectName
   */
  public void addCIBService(ObjectName objectName);

  /**
   * Allows to remove a CIBService objectName from the list DeployedServices
   * @param objectName ObjectName
   * @throws CIBException
   */
  public void removeCIBService(ObjectName objectName) throws CIBException;

  /**
   * Allows to add a CIBResource objectName in the list of ConsumedResources
   * @param objectName ObjectName
   */
  public void addCIBResource(ObjectName objectName);

  /**
   * Allows to remove a CIBResource object name from the list of ConsumedResources
   * @param objectName ObjectName
   * @throws CIBException
   */
  public void removeCIBResource(ObjectName objectName) throws CIBException;

  /**
   * Allows to add an CIBExternalResource to the list of ConsumedServices
   * @param objectName ObjectName
   */
  public void addCIBExternalResource(ObjectName objectName);

  /**
   * Allows to remove an an CIBExternalService from the list of ConsumedServices
   * @param objectName ObjectName
   * @throws CIBException
   */
  public void removeCIBExternalResource(ObjectName objectName) throws
      CIBException;

  /**
   *  Allows to set the CIBApplication Container object Name
   * @param objectName ObjectName
   */
  public void setApplicationContainer(ObjectName objectName);

  /**
   * Returns the CIBProduct the CIBApplication has been deployed
   * @param objectName ObjectName
   */
  public void setCIBProduct(ObjectName objectName);
}
