/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 * 
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)convert.c 1.3     04/05/19 SMI"
 *
 */


/*
 *
 * convert.c - Connector server
 *
 *                                                                  * 
 */

#include <pthread.h>
#include <errno.h>
#include <string.h>
#include <stdio.h>
#include <malloc.h>
#include <strings.h>
#include <plhash.h>

#include "mfRserver.h"



/*
 * 
 * caststring2resource
 *
 * Transform the string value into a resource
 */
void caststring2resource(char *value, int type,void *resource) {
#if 0 
  long long res;
  char *value_low;
  char *value_high;  
#endif
  switch (type) {

  case MF_TYPE_CHAR:
    sscanf(value,"%c",(char *)  resource);
    break;

  case MF_TYPE_DOUBLE:
    sscanf(value,"%g",(double *) resource);
    break;

  case MF_TYPE_FLOAT:
    sprintf(value,"%g",(float *) resource);
    break; 

  case MF_TYPE_INT:
    sscanf(value,"%d", (int *) resource);
    break;

  case MF_TYPE_LONGLONG:
#if 0
    //value_low = value;
    //value_high = value + 4;
    //sscanf(value_low,"%lx",(long *) resource);
    //sscanf(value_high,"%lx",(long *) (resource+4));
#endif
    break;

  case MF_TYPE_SHORT:
    sscanf(value,"%x",(short *) resource);
    break;

  case MF_TYPE_STRING:
    sscanf(value,"%s",(char *) resource);
    break;
     
  default:
    break;

  }

}




/*
 * castresource2string 
 *
 * Transform the resource value into a string
 *
 * Note:
 * for types which are: int short long, the value
 * is transformed into an hexadecimal string
 */
void castresource2string(char *value, int type,void *resource) {
  long long res;
  long res_low;
  long res_high;


  if (value != NULL) {
    switch (type) {

    case MF_TYPE_BOOLEAN:
      if (*(int *) resource == 0) {
	strcpy(value,"false");	
      }
      else {
	strcpy(value,"true");
      }
				    
      break;

  
    case MF_TYPE_CHAR:
      sprintf(value,"%c",*(char *) resource);
      break;

    case MF_TYPE_DOUBLE:
      sprintf(value,"%g",*(double *) resource);
      break;

    case MF_TYPE_FLOAT:
      sprintf(value,"%g",*(float *) resource);
      break; 

    case MF_TYPE_INT:
      sprintf(value,"%x",*(int *) resource);
      break;

    case MF_TYPE_LONGLONG:
      res = *(long long *) resource;
      res_low = (res & 0xfffffffff) ;
      res_high = (res >> 32);
      sprintf(value,"%lx%lx",res_high,res_low);
      break;

    case MF_TYPE_SHORT:
      sprintf(value,"%x",*(short *) resource);
      break;

    case MF_TYPE_STRING:
      sprintf(value,"%s",(char *) resource);
      break;
     
    default:
      break;

    }
  }
}





