/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 * 
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits rservs.
 * Ce logiciel est proprit de Sun Microsystems, Inc.
 * Distribu par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)mfDiscovery.h 1.11     04/09/29 SMI"
 *
 */



/*
 * mfDiscovery.h - Discovery header file
 * 
 */


#ifndef MF_DISCOVERY_H_INCLUDED
#define MF_DISCOVERY_H_INCLUDED

#include "mfConstant.h"


#define DISCOVERY_MAGIC_NUMBER "MFVER1"
#define DISCOVERY_HEADER_SIZE  sizeof(discoveryObject_t)
#define JES_VERSION  3
#define DISC_VERSION 1

#define DISCOVERY_RESPONSE "RESPONSE"
#define DISCOVERY_TAG      "DISCOVER"
  
   

#define HELLO_PORT 12345
#define HELLO_GROUP "225.225.225.1"


#define DEFAULT_MCAST_GROUP "225.225.225.1"
#define DEFAULT_MCAST_PORT 12345



#define MCASTGROUP "mfwk.multicast.group"
#define MCASTPORT  "mfwk.multicast.port"
#define MCASTDISABLELOOPBACK "mfwk.multicast.disableloopback"
#if defined(sun) || defined(__sun__) 
#define AGENT_PROPERTY_FILE "/etc/opt/SUNWmfwk/agent.properties"
#elif defined(__linux__)
#define AGENT_PROPERTY_FILE "/etc/opt/sun/mfwk/agent.properties"
#else
# error "Unsupported System"
#endif


#define MAXBUFSIZE 65536 /* Max UDP Packet size is 64 Kbyte*/


/* fix bug ID 5108636 
  Missing extern "C" for cplusplus
*/

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

typedef struct disc {
  /* header */
  char magic[6];        /* "US-ASCII" encoding*/
  short hdrsize;
  char msgtype[8];      /* "US-ASCII" encoding*/
  short securityLevel;
  short jesversion;
  short discversion;
  short productsize;
  short productinstancesize;
  short urisize;
  short userdatasize;
  short res1size;
  short res2size;
  short res3size;
  short res4size;
  short res5size;
} discoveryObject_t ;			

int mfDiscoveryResponder(char *productName, 
			char *productInstance, 
			char *uri, 
			unsigned char *userData );

#ifdef __cplusplus
     }
#endif /* __cplusplus */

       
#endif /* JESMF_H_INCLUDED */
