/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 * 
 * Copyright 2004 Sun Microsystems, Inc.  Tous droits r?serv?s.
 * Ce logiciel est propri?t? de Sun Microsystems, Inc.
 * Distribu? par des licences qui en restreignent l'utilisation.
 *
 * ident        "@(#)discoveryExample_Module.java 1.6     04/06/29 SMI"
 *
 */


package com.sun.mfwk.examples.discovery;

// J2SE
import java.util.logging.Logger;

// JMX
import javax.management.ObjectName;
import javax.management.NotificationListener;
import javax.management.Notification;
import javax.management.NotificationFilterSupport;
import javax.management.MBeanRegistrationException;

// Cacao
import com.sun.cacao.DeploymentDescriptor;
import com.sun.cacao.Module;
import com.sun.cacao.ModuleMBean;

// CP
import com.sun.mfwk.util.log.MfLogService;
import com.sun.mfwk.discovery.MfDiscoveryInfo;


/**
 * The discoveryExample_Module is *NOT* a complete CP module example
 * Its intent is to show how Discovery Information can be retrieved 
 * on the CP module side.
 * What it does is to retrieve the info filled in the discovery SDK
 * and display them in the Agent logs.
 * Look at complete example to see how to integrate the discovery
 * part into a real example including the CIB....
 */
public class discoveryExample_Module extends Module implements NotificationListener {

    // In the CP module the CP name is known
    // and can be used to filter the notification 
    // (notification type = product Name) or
    // to compare it with the product field contained in the 
    // MfDiscoveryInfo field
    String prodName = "DiscoveryExampleCPName";
    
    // Tracing utility.
    private static Logger logger =
        MfLogService.getLogger("discoveryExample_module");
    
    public discoveryExample_Module(DeploymentDescriptor descriptor) {
        super(descriptor);
    }

    /**
     * Describe <code>start</code> method here.
     *
     */
    protected void start() {

        logger.info("discoveryExample_Module is starting");
        NotificationFilterSupport myFilter = new NotificationFilterSupport();
        myFilter.enableType(this.prodName);   
        
        try {
            ObjectName discoveryServiceObjectName = new ObjectName("com.sun.mfwk.mfwk_module:type=mfDiscoveryService,name=mfDiscoveryService");
            getMbs().addNotificationListener(discoveryServiceObjectName, (NotificationListener) this, myFilter, null);
        } catch(Exception e) {
            logger.warning("cannot succeed in adding listener on mfDiscoveryService: " + e.getMessage());
        }
    }

     public void handleNotification(Notification notification, Object handback) {

	try {
		logger.info("\nDiscoveryInfo are received in JMX notification:");
                String type = notification.getType();
		logger.info("Notification Type is equal to product Name => can be filtered:" + type + "\n");

                //cast Notfi UserData to DicoveryInfo
		MfDiscoveryInfo receivedMsg = null;
		receivedMsg = (com.sun.mfwk.discovery.MfDiscoveryInfo) notification.getUserData();

                logger.info("Product: " + receivedMsg.getProduct() + " - productInstance: " + receivedMsg.getProductInstance()  + " - URI: " + receivedMsg.getUri());
                logger.info("ProductInstance: " + receivedMsg.getProductInstance() + " - productInstance: " + receivedMsg.getProductInstance()  + " - URI: " + receivedMsg.getUri());
                logger.info("ProductUri: " + receivedMsg.getUri() + " - productInstance: " + receivedMsg.getProductInstance()  + " - URI: " + receivedMsg.getUri());
                logger.info("ProductUserData: " + receivedMsg.getUserData().length + " - productInstance: " + receivedMsg.getProductInstance()  + " - URI: " + receivedMsg.getUri());          		

	} catch (Throwable e) {
		logger.warning("Caught Exception : " + e.toString() + " message : " + e.getMessage());
		e.printStackTrace();
	}
    }

    /**
     * Describe <code>stop</code> method here.
     *
     */
    protected void stop() {

    }


}

