/*
 * Copyright (c) 2004
 */
#include <sys/types.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <sys/mman.h>
#include <netinet/in.h>

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <syslog.h>
#include <unistd.h>
#include <errno.h>
#include <assert.h>
#include <string.h>
#include <pthread.h>
#include <fcntl.h>


#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>

#include "circfile.h"




#ifdef _WIN32
#  include <getopt.h>
#else
#  include <sys/time.h>
#endif

#include "httpd.h"

#include "mfDiscovery.h"
#include "mfCserver.h"
#include "mfRserver.h"
#include "mfUtils.h"
#include "mfTransaction.h"

/*
 * This is a static page of HTML.  It is loaded into the content
 * tree using httpdAddStaticContent( ).
 */
#define test1_html "<HTML><BODY>This is just a test</BODY>"


static   mfResourceObject_t HTTP_SRVStatus;
static   mfStatus_t  Status;


static  int portNumber;


static char objectNameInstrumManagement[80];
static char objectNameInstrumConfig[80];
static char objectNameInstrumStatus[80];









static mfTransactionMetrics_t    transactionMetrics_login;
static mfResourceObject_t resourceMetricsTransaction_login;
static unsigned short transId_login;
static char objectNameTransactionMetrics_login[80];

static mfTransactionMetrics_t    transactionMetrics_wildcard;
static mfResourceObject_t resourceMetricsTransaction_wildcard;
static unsigned short transId_wildcard;
static char objectNameTransactionMetrics_wildcard[80];

static mfTransactionMetrics_t    transactionMetrics_display;
static mfResourceObject_t resourceMetricsTransaction_display;
static unsigned short transId_display;
static char objectNameTransactionMetrics_display[80];


static mfResourceMetrics_t  resourceMetrics_circfile;
static mfResourceObject_t resourceMetricsResource_circfile;
static char objectNameResourceMetrics_circfile[80];



static mfInstrumConfig_t instrumConfig;
static mfResourceObject_t resourceInstrumConfig;

static mfInstrumManagement_t instrumManagement;
static mfResourceObject_t resourceInstrumManagement;


static struct circfile *cf;

long long NbOperations;


void displaytransaction(mfTransactionMetrics_t *transactionMetricsPtr, char *buffdisplay) 
{
  char buffer[256];

  bzero(buffdisplay,strlen(buffdisplay));
  
  sprintf(buffer,"<P>transactionMetricsPtr->AvailabilityState %ld <P> \n", transactionMetricsPtr->AvailabilityState) ;
  strcat(buffdisplay,buffer);
  sprintf(buffer,"transactionMetricsPtr->AvailStateLastChange  %lld <P> \n", transactionMetricsPtr->AvailStateLastChange );
  strcat(buffdisplay,buffer);	  
  sprintf(buffer,"transactionMetricsPtr->DegradedTime %lld <P> \n", transactionMetricsPtr->DegradedTime) ;
  strcat(buffdisplay,buffer);
  sprintf(buffer,"transactionMetricsPtr->OperationalState %ld <P>\n",transactionMetricsPtr->OperationalState );
  strcat(buffdisplay,buffer);
  sprintf(buffer,"transactionMetricsPtr->OpsStateLastChange %lld <P>\n",  transactionMetricsPtr->OpsStateLastChange);
  strcat(buffdisplay,buffer);
  sprintf(buffer,"transactionMetricsPtr->RunningTime %lld <P>\n",  transactionMetricsPtr->RunningTime);   
  strcat(buffdisplay,buffer);
  sprintf(buffer,"transactionMetricsPtr->isMonitoringEnabled %lld <P>\n",  transactionMetricsPtr->isMonitoringEnabled);
  strcat(buffdisplay,buffer);


  sprintf(buffer,"transactionMetricsPtr->AccumulatedResponseTime %lld <P>\n",transactionMetricsPtr->AccumulatedResponseTime);
  strcat(buffdisplay,buffer);
  sprintf(buffer,"transactionMetricsPtr->AccumulatedServiceTime %lld <P>\n",transactionMetricsPtr->AccumulatedServiceTime);
  strcat(buffdisplay,buffer);
  sprintf(buffer,"transactionMetricsPtr->AccumulatedSqResponseTime %lld <P>\n",transactionMetricsPtr->AccumulatedSqResponseTime);
  strcat(buffdisplay,buffer);
  sprintf(buffer,"transactionMetricsPtr->AccumulatedSqServiceTime %lld <P>\n",transactionMetricsPtr->AccumulatedSqServiceTime);
  strcat(buffdisplay,buffer);
  sprintf(buffer,"transactionMetricsPtr->MaxResponseTime %lld <P>\n",transactionMetricsPtr->MaxResponseTime);
  strcat(buffdisplay,buffer);
  sprintf(buffer,"transactionMetricsPtr->MaxServiceTime %lld <P>\n",transactionMetricsPtr->MaxServiceTime);
  strcat(buffdisplay,buffer);
  sprintf(buffer,"transactionMetricsPtr->MinResponseTime %lld <P>\n",transactionMetricsPtr->MinResponseTime);
  strcat(buffdisplay,buffer);
  sprintf(buffer,"transactionMetricsPtr->MinServiceTime %lld <P>\n",transactionMetricsPtr->MinServiceTime);
  strcat(buffdisplay,buffer);
  sprintf(buffer,"transactionMetricsPtr->NbFailedRequests %lld <P>\n",transactionMetricsPtr->NbFailedRequests);
  strcat(buffdisplay,buffer);
  sprintf(buffer,"transactionMetricsPtr->NbInRequests %lld <P>\n",transactionMetricsPtr->NbInRequests);
  strcat(buffdisplay,buffer);
  sprintf(buffer,"transactionMetricsPtr->NbOutRequests %lld <P>\n",transactionMetricsPtr->NbOutRequests);
  strcat(buffdisplay,buffer);
  sprintf(buffer,"transactionMetricsPtr->SingleAccumulatedServiceTime %lld <P>\n",transactionMetricsPtr->SingleAccumulatedServiceTime);
  strcat(buffdisplay,buffer);
  sprintf(buffer,"transactionMetricsPtr->SingleAccumulatedSqServiceTime %lld <P>\n",transactionMetricsPtr->SingleAccumulatedSqServiceTime);
  strcat(buffdisplay,buffer);
  sprintf(buffer,"transactionMetricsPtr->SingleMaxServiceTime %lld <P>\n",transactionMetricsPtr->SingleMaxServiceTime);
  strcat(buffdisplay,buffer);
  sprintf(buffer,"transactionMetricsPtr->SingleMinServiceTime %lld <P>\n",transactionMetricsPtr->SingleMinServiceTime);
  strcat(buffdisplay,buffer);
  sprintf(buffer,"transactionMetricsPtr->SingleNbFailedRequests %lld <P>\n",transactionMetricsPtr->SingleNbFailedRequests);
  strcat(buffdisplay,buffer);
  sprintf(buffer,"transactionMetricsPtr->Uri %s <P>\n",transactionMetricsPtr->Uri);    
  strcat(buffdisplay,buffer);  

  
  if (circfile_put(cf, buffdisplay, strlen(buffdisplay) + 1) == -1) {
         printf("warning: circfile_put: failed\n");
	 /*resourceMetrics_circfile.FailedOperations++; */
	 
  }
  else {
      resourceMetrics_circfile.NbOperations++;
  }
}






void displayresource(mfResourceMetrics_t *resourceMetricsPtr, char *buffdisplay) 
{
  char buffer[256];

  bzero(buffdisplay,strlen(buffdisplay));
  
  sprintf(buffer,"<P>resourceMetricsPtr->AvailabilityState %ld <P> \n", resourceMetricsPtr->AvailabilityState) ;
  strcat(buffdisplay,buffer);
  sprintf(buffer,"resourceMetricsPtr->AvailStateLastChange  %lld <P> \n", resourceMetricsPtr->AvailStateLastChange );
  strcat(buffdisplay,buffer);	  
  sprintf(buffer,"resourceMetricsPtr->DegradedTime %lld <P> \n", resourceMetricsPtr->DegradedTime) ;
  strcat(buffdisplay,buffer);
  sprintf(buffer,"resourceMetricsPtr->OperationalState %ld <P>\n",resourceMetricsPtr->OperationalState );
  strcat(buffdisplay,buffer);
  sprintf(buffer,"resourceMetricsPtr->OpsStateLastChange %lld <P>\n",  resourceMetricsPtr->OpsStateLastChange);
  strcat(buffdisplay,buffer);
  sprintf(buffer,"resourceMetricsPtr->RunningTime %lld <P>\n",  resourceMetricsPtr->RunningTime);   
  strcat(buffdisplay,buffer);
  sprintf(buffer,"resourceMetricsPtr->isMonitoringEnabled %lld <P>\n",  resourceMetricsPtr->isMonitoringEnabled);
  strcat(buffdisplay,buffer);


  sprintf(buffer,"resourceMetricsPtr->AccumulatedOperationTime %lld <P>\n",resourceMetricsPtr->AccumulatedOperationTime);
  strcat(buffdisplay,buffer);
  sprintf(buffer,"resourceMetricsPtr->AccumulatedSqOperationTime %lld <P>\n",resourceMetricsPtr->AccumulatedSqOperationTime);
  strcat(buffdisplay,buffer);
  sprintf(buffer,"resourceMetricsPtr->FailedOperation %lld <P>\n",resourceMetricsPtr->FailedOperations);
  strcat(buffdisplay,buffer);

  sprintf(buffer,"resourceMetricsPtr->MaxOperationTime %lld <P>\n",resourceMetricsPtr->MaxOperationTime);
  strcat(buffdisplay,buffer);
  sprintf(buffer,"resourceMetricsPtr->MinOperationTime %lld <P>\n",resourceMetricsPtr->MinOperationTime);
  strcat(buffdisplay,buffer);
  sprintf(buffer,"resourceMetricsPtr->NbOperations %lld <P>\n",resourceMetricsPtr->NbOperations);
  strcat(buffdisplay,buffer);
 
}












/*
 * Below are 2 dynamic pages, each generated by a C function.  The first
 * is a simple page that offers a little dynamic info (the process ID)
 * and the setups up a test link and a simple form.
 * 
 * The second page processes the form.  As you can see, you can access
 * the form data from within your C code by accessing the symbol table
 * using httpdGetVariableByName() (and other similar functions).  You
 * can also include variables in the string passed to httpdOutput( ) and
 * they will be expanded automatically.
 */
void index_html(httpd *server)
{

    httpdPrintf(server,
		"Welcome to the httpd server running in process number %d<P>\n",
		getpid());
    
    httpdPrintf(server,
		"<p> <b>Instrumention Management:</b> \
                    <ul>  \
                     <li> <A HREF=/enable.html>Enable Instrumentation</A> (Global Level)</li> \
                     <li> <A HREF=/disable.html>Disable Instrumentation</A> (Global Level)</li> \
                    </ul>");

    httpdPrintf(server,
		"<p> <b>Login Service:</b> \
                    <ul>  \
                     <li> <A HREF=/enable_login.html>Enable Login</A> (Service Level)</li> \
                     <li> <A HREF=/disable_login.html>Disable Login</A> (Service Level)</li> \
                     <li> <A HREF=/login.html>Test Login</A></li> \
                    </ul>");

    httpdPrintf(server,
		"<p> <b>WildCard Service:</b> \
                    <ul>  \
                     <li> <A HREF=/enable_wildcard.html>Enable WildCard</A> (Service Level)</li> \
                     <li> <A HREF=/disable_wildcard.html>Disable WildCard</A> (Service Level)</li> \
                     <li> <A HREF=/wildcard/foo>Test Wildcard</A></li> \
                    </ul>");


    
    httpdPrintf(server,
		"<p> <b>Display Service:</b> \
                    <ul>  \
                     <li> <A HREF=/enable_display.html>Enable Display</A> (Service Level)</li> \
                     <li> <A HREF=/disable_display.html>Disable Display</A> (Service Level)</li> \
                          <FORM ACTION=/display.html METHOD=POST> \
                     <li> Test Display: </li>\
                           Enter your name <INPUT NAME=name SIZE=10\
                               <INPUT TYPE=SUBMIT VALUE=Click!> \
                    </ul>");
   
    httpdPrintf(server,
		"<p> <b>Circ File Resource:</b> \
                    <ul>  \
                     <li> <A HREF=/enable_circfile.html>Enable CircFile </A> (Resource Level)</li> \
                     <li> <A HREF=/disable_circfile.html>Disable CirCfile</A>(Resource Level)</li> \
                     <li> <A HREF=/display_circfile.html>Display Cirfile Resource</A></li> \
                    </ul>");

    


    return;
}

void display_html(httpd *server)
{
    httpVar *variable;
    handle_t trans_handle_display;
    char bufferdisplay[8192];

    /*
     * Grab the symbol table entry to see if the variable exists
     */

    mfStartTransaction(transId_display, NULL, &trans_handle_display);
    variable = httpdGetVariableByName(server, "name");
    if (variable == NULL) {
        httpdPrintf(server,"Missing form data!");
	return;
    }

    /*
     * Use httpdOutput() rather than httpdPrintf() so that the variable
     * embedded in the text is expanded automatically
     */
    httpdOutput(server, 
		"Click <A HREF=/index.html>here</A> to go index <P> <P>");
    httpdOutput(server,"Hello $name <P>");
    mfStopTransaction(transId_display,&trans_handle_display,STATUS_GOOD);
    displaytransaction(&transactionMetrics_display,bufferdisplay);
    httpdPrintf(server,bufferdisplay);
}




void display_circfile(httpd *server)
{
    char bufferdisplay[8192];

    /*
     * Grab the symbol table entry to see if the variable exists
     */

   
    

    /*
     * Use httpdOutput() rather than httpdPrintf() so that the variable
     * embedded in the text is expanded automatically
     */
    httpdOutput(server, 
		"Click <A HREF=/index.html>here</A> to go index <P> <P>");
    
    displayresource(&resourceMetrics_circfile, bufferdisplay);
    httpdPrintf(server,bufferdisplay);
}










void enable_html(httpd *server)
{
  int rc;
  void *value;
  int type;
  AttValue_array paramsArray;
  String_array signatureArray; 
   
 
  rc = mfInvokeResource(objectNameInstrumManagement,"enableMonitoring",
			paramsArray,
			signatureArray, 
			&value,  
			&type);
    
  httpdOutput(server, 
		"Click <A HREF=/index.html>here</A> to go index <P> <P>");
  httpdPrintf(server,"Enable done rc = %d <P>",rc );
   
}

void disable_html(httpd *server)
{
  int rc;
  void *value;
  int type;
  AttValue_array paramsArray;
  String_array signatureArray; 
   
 
  rc = mfInvokeResource(objectNameInstrumManagement,"disableMonitoring",
			paramsArray,
			signatureArray, 
			&value,  
			&type);
    
  httpdOutput(server, 
		"Click <A HREF=/index.html>here</A> to go index <P> <P>");
  httpdPrintf(server,"Disable done rc = %d <P>",rc );
   
}

void enable_login_html(httpd *server)
{
  int rc;
  void *value;
  int type;
  AttValue_array paramsArray;
  String_array signatureArray; 
   
 
  rc = mfInvokeResource(objectNameTransactionMetrics_login,"enableMonitoring",
			paramsArray,
			signatureArray, 
			&value,  
			&type);
    
  httpdOutput(server, 
		"Click <A HREF=/index.html>here</A> to go index <P> <P>");
  httpdPrintf(server,"Enable done rc = %d <P>",rc );
   
}

void disable_login_html(httpd *server)
{
  int rc;
  void *value;
  int type;
  AttValue_array paramsArray;
  String_array signatureArray; 
   
 
  rc = mfInvokeResource(objectNameTransactionMetrics_login,"disableMonitoring",
			paramsArray,
			signatureArray, 
			&value,  
			&type);
    
  httpdOutput(server, 
		"Click <A HREF=/index.html>here</A> to go index <P> <P>");
  httpdPrintf(server,"Disable done rc = %d <P>",rc );
   
}




void enable_circfile_html(httpd *server)
{
  int rc;
  void *value;
  int type;
  AttValue_array paramsArray;
  String_array signatureArray; 
   
 
  rc = mfInvokeResource(objectNameResourceMetrics_circfile,"enableMonitoring",
			paramsArray,
			signatureArray, 
			&value,  
			&type);
    
  httpdOutput(server, 
		"Click <A HREF=/index.html>here</A> to go index <P> <P>");
  httpdPrintf(server,"Enable done rc = %d <P>",rc );
   
}

void disable_circfile_html(httpd *server)
{
  int rc;
  void *value;
  int type;
  AttValue_array paramsArray;
  String_array signatureArray; 
   
 
  rc = mfInvokeResource(objectNameResourceMetrics_circfile,"disableMonitoring",
			paramsArray,
			signatureArray, 
			&value,  
			&type);
    
  httpdOutput(server, 
		"Click <A HREF=/index.html>here</A> to go index <P> <P>");
  httpdPrintf(server,"Disable done rc = %d <P>",rc );
   
}









void enable_wildcard_html(httpd *server)
{
  int rc;
  void *value;
  int type;
  AttValue_array paramsArray;
  String_array signatureArray; 
   
 
  rc = mfInvokeResource(objectNameTransactionMetrics_wildcard,"enableMonitoring",
			paramsArray,
			signatureArray, 
			&value,  
			&type);
    
  httpdOutput(server, 
		"Click <A HREF=/index.html>here</A> to go index <P> <P>");
  httpdPrintf(server,"Enable done rc = %d <P>",rc );
   
}

void disable_wildcard_html(httpd *server)
{
  int rc;
  void *value;
  int type;
  AttValue_array paramsArray;
  String_array signatureArray; 
   
 
  rc = mfInvokeResource(objectNameTransactionMetrics_wildcard,"disableMonitoring",
			paramsArray,
			signatureArray, 
			&value,  
			&type);
    
  httpdOutput(server, 
		"Click <A HREF=/index.html>here</A> to go index <P> <P>");
  httpdPrintf(server,"Disable done rc = %d <P>",rc );
   
}


void enable_display_html(httpd *server)
{
  int rc;
  void *value;
  int type;
  AttValue_array paramsArray;
  String_array signatureArray; 
   
 
  rc = mfInvokeResource(objectNameTransactionMetrics_display,"enableMonitoring",
			paramsArray,
			signatureArray, 
			&value,  
			&type);
    
  httpdOutput(server, 
		"Click <A HREF=/index.html>here</A> to go index <P> <P>");
  httpdPrintf(server,"Enable done rc = %d <P>",rc );
   
}

void disable_display_html(httpd *server)
{
  int rc;
  void *value;
  int type;
  AttValue_array paramsArray;
  String_array signatureArray; 
   
 
  rc = mfInvokeResource(objectNameTransactionMetrics_display,"disableMonitoring",
			paramsArray,
			signatureArray, 
			&value,  
			&type);
    
  httpdOutput(server, 
		"Click <A HREF=/index.html>here</A> to go index <P> <P>");
  httpdPrintf(server,"Disable done rc = %d <P>",rc );
   
}


void busy_computation() {

  double f ;
  double value;
  long i;
  
  value = 0;
  f = 0;
  i = 0;

  /*sleep(3); */
   for (i = 0; i < 1000000 ; i++ ) 
    {
      value = (double ) i;
      f = f + (value * value);

    }
}



void wildcard_html(httpd *server)
{
    char *path;
    handle_t trans_handle_wildcard;
    char bufferdisplay[8192];

    mfStartTransaction(transId_wildcard, NULL, &trans_handle_wildcard);
    busy_computation();

    path = httpdRequestPath(server);
    httpdOutput(server, 
		"Click <A HREF=/index.html>here</A> to go index <P> <P>");
    httpdOutput(server,"Wilcard dynamic request received<P>");
    httpdPrintf(server,"The requested path was %s<P>", path);
    mfStopTransaction(transId_wildcard,&trans_handle_wildcard,STATUS_GOOD);
     
    displaytransaction(&transactionMetrics_wildcard,bufferdisplay);
    httpdPrintf(server,bufferdisplay);
}






void login_html(httpd *server)
{
   handle_t trans_handle_login;
   char bufferdisplay[8192];

    mfStartTransaction(transId_login, NULL, &trans_handle_login);
    if (httpdAuthenticate(server, "LibHTTPD Test") != 0) {
      mfStopTransaction(transId_login,&trans_handle_login,STATUS_FAILED);
      return;
    }
    httpdOutput(server, 
		"Click <A HREF=index.html>here</A> to go index <P> <P>");
    httpdPrintf(server, "Your username is '%s'<P>\n",
		server->request.authUser);
    httpdPrintf(server, "Your password is '%s'<P>\n",
 		server->request.authPassword);
    httpdOutput(server, 
		"Click <A HREF=login2.html>here</A> to force reauthentication");
    httpdOutput(server, ".  Use a username = test password = 123");

    mfStopTransaction(transId_login,&trans_handle_login,STATUS_GOOD);
    displaytransaction(&transactionMetrics_login,bufferdisplay);
    httpdPrintf(server,bufferdisplay);
}



void login2_html(httpd *server)
{
  handle_t trans_handle_login2;
  char bufferdisplay[8192];
  
  mfStartTransaction(transId_login, NULL, &trans_handle_login2);
  
  
    if (httpdAuthenticate(server, "LibHTTPD Test") != 0) {
        httpdOutput(server, "Authentication failure(1).");
	mfStopTransaction(transId_login,&trans_handle_login2,STATUS_FAILED);
	displaytransaction(&transactionMetrics_login,bufferdisplay);
	httpdPrintf(server,bufferdisplay);
	return;
    }

    if (strcmp(server->request.authUser, "test") != 0 ||
	  strcmp(server->request.authPassword, "123") != 0) {
        httpdForceAuthenticate(server, "LibHTTPD Test");
	httpdOutput(server, "Authentication failure (2).");
	mfStopTransaction(transId_login,&trans_handle_login2,STATUS_FAILED);
	displaytransaction(&transactionMetrics_login,bufferdisplay);
	httpdPrintf(server,bufferdisplay);
	return;
    }
    httpdOutput(server, 
		"Click <A HREF=/index.html>here</A> to go index <P> <P>");
    httpdOutput(server, "Your login was accepted.");
    mfStopTransaction(transId_login,&trans_handle_login2,STATUS_GOOD);
    displaytransaction(&transactionMetrics_login,bufferdisplay);
    httpdPrintf(server,bufferdisplay);
    
}



void mfHttpdInit(int port)
{
    int rc;
    char *ProductName;
    char *ProductInstance;
    char Uri[10]; 
    long status_value;
    long long time_value;
    long avail_value;
    char config_string[40];
   



    /* create connector server */

    rc = mfCreateConnectorServer(&portNumber);
    if (rc != MF_SUCCESS) {
      printf("mfCreateConnectorServer creation failed %d\n",rc);
    }



    /* create resource server */
    rc = mfCreateResourceServer();
    if (rc != MF_SUCCESS) {
      printf("mfCreateConnectorServer creation failed %d\n",rc);
    }



  
    
    /* Instanciate the MfStatus Metrics MBean for the test_httpd Application */

    rc = mfRegisterStatus(&HTTP_SRVStatus,&Status,80,objectNameInstrumStatus);
    if (rc != MF_SUCCESS) {
      printf("mfRegisterStatus failed rc %d\n",rc);
    }
    
    status_value = OPS_STARTING ;
    mfSetResourceAttribute(objectNameInstrumStatus,
    			   "OperationalState",
    			   (void *) &status_value);

    /* register instrum config */
    rc = mfRegisterInstrumConfig(&resourceInstrumConfig,
			       (void *) &instrumConfig,
			       80,
			       objectNameInstrumConfig);
    if (rc != MF_SUCCESS) {
      printf("mfRegisterInstrumConfig failed rc %d\n",rc);
    }

   
  


    strcpy(config_string,"standalone server");
    rc = mfSetResourceAttribute(objectNameInstrumConfig,
    			   "AppRole",
    			   (void *) "standalone server");
    if (rc != MF_SUCCESS) {
      printf("mfSetResourceAttribute failed for rc InstrumConfig  AppRole %d\n",rc);
    }


    strcpy(config_string,"HTTP_SRV URL description");
    rc = mfSetResourceAttribute(objectNameInstrumConfig,
    			   "AppURLDescription",
    			   (void *) "HTTP_SRV URL description");
    if (rc != MF_SUCCESS) {
      printf("mfSetResourceAttribute failed for rc InstrumConfig AppURLDescription  %d\n",rc);
    }


    strcpy(config_string,"HTTP_SRV Directory DN");
    rc = mfSetResourceAttribute(objectNameInstrumConfig,
    			   "AppDirectoryDN",
    			   (void *) &config_string);
    if (rc != MF_SUCCESS) {
      printf("mfSetResourceAttribute failed for rc InstrumConfig AppURLDescription  %d\n",rc);
    }



  


    /* register intrum nanagement */
    rc = mfRegisterInstrumManagement(&resourceInstrumManagement,
				  (void *) &instrumManagement,
				  80,
				  objectNameInstrumManagement);
    if (rc != MF_SUCCESS) {
      printf("mfRegisterInstrumManagement failed rc %d\n",rc);
    }



    /* register and Instantiate transactionMetrics_display */
    rc = mfRegisterResourceTransactionMetrics(&resourceMetricsTransaction_display,
				   "DISPLAY",
				   "/display.hml",
				   &transactionMetrics_display,
				   80,
				   objectNameTransactionMetrics_display,
				   &transId_display);
    if (rc != MF_SUCCESS) {
      printf("mfRegisterTransactionMetrics for transactionMetrics_display failed rc %d\n",rc);
    }
    
    status_value = OPS_STARTING ;
    rc = mfSetResourceAttribute(objectNameTransactionMetrics_display,
    			   "OperationalState",
    			   (void *) &status_value);
    
    if (rc != MF_SUCCESS) {
      printf("mfSetResourceAttribute for transactionMetrics_test1 failed rc %d\n",rc);
    }


    /* register and Instantiate transactionMetrics_login */
    rc = mfRegisterResourceTransactionMetrics(&resourceMetricsTransaction_login,
				   "LOGIN",
				   "/login.hml",
				   &transactionMetrics_login,
				   80,
				   objectNameTransactionMetrics_login,
				   &transId_login);
    if (rc != MF_SUCCESS) {
      printf("mfRegisterTransactionMetrics for transactionMetrics_login failed rc %d\n",rc);
    }

    status_value = OPS_STARTING ;
    rc = mfSetResourceAttribute(objectNameTransactionMetrics_login,
    			   "OperationalState",
    			   (void *) &status_value);
    if (rc != MF_SUCCESS) {
      printf("mfSetResourceAttribute for transactionMetrics_login failed rc %d\n",rc);
    }

		     

    
    /* register and Instantiate transactionMetrics_wildcard */
    rc = mfRegisterResourceTransactionMetrics(&resourceMetricsTransaction_wildcard,
				   "WILDCARD",
				   "/wildcard.hml",
				   &transactionMetrics_wildcard,
				   80,
				   objectNameTransactionMetrics_wildcard,
				   &transId_wildcard);
    if (rc != MF_SUCCESS) {
      printf("mfRegisterTransactionMetrics for transactionMetrics_wildcard failed rc %d\n",rc);
    }

    status_value = OPS_STARTING ;
    rc = mfSetResourceAttribute(objectNameTransactionMetrics_wildcard,
    			   "OperationalState",
    			   (void *) &status_value);
    if (rc != MF_SUCCESS) {
      printf("mfSetResourceAttribute for transactionMetrics_wildcard failed rc %d\n",rc);
    }

   
    /*
    ** manage operational status and availability status
    */
    status_value = OPS_RUNNING;
    mfSetResourceAttribute(objectNameInstrumStatus,
    			   "OperationalState",
    			   (void *) &status_value);
    if (rc != MF_SUCCESS) {
      printf("mfSetResourceAttribute for objectNameInstrumStatus failed rc %d\n",rc);
    }


    rc = mfSetResourceAttribute(objectNameTransactionMetrics_login,
    			   "OperationalState",
    			   (void *) &status_value);
    if (rc != MF_SUCCESS) {
      printf("mfSetResourceAttribute for objectNameTransactionMetrics_login failed rc %d\n",rc);
    }


    rc = mfSetResourceAttribute(objectNameTransactionMetrics_wildcard,
    			   "OperationalState",
    			   (void *) &status_value);
    if (rc != MF_SUCCESS) {
      printf("mfSetResourceAttribute for objectNameTransactionMetrics_wildcard failed rc %d\n",rc);
    }


    rc = mfSetResourceAttribute(objectNameTransactionMetrics_display,
    			   "OperationalState",
    			   (void *) &status_value); 
   if (rc != MF_SUCCESS) {
      printf("mfSetResourceAttribute for  objectNameTransactionMetrics_display failed rc %d\n",rc);
    }

   
   /* set operational state last change */
   time_value = mfgetCurrentTimeMillis();
   mfSetResourceAttribute(objectNameInstrumStatus,
    			   "OpsStateLastChange",
    			   (void *) &time_value);
    if (rc != MF_SUCCESS) {
      printf("mfSetResourceAttribute (timevalue) for objectNameInstrumStatus failed rc %d\n",rc);
    }


    rc = mfSetResourceAttribute(objectNameTransactionMetrics_login,
    			   "OpsStateLastChange",
    			   (void *) &time_value);
    if (rc != MF_SUCCESS) {
      printf("mfSetResourceAttribute (timevalue) for objectNameTransactionMetrics_login failed rc %d\n",rc);
    }


    rc = mfSetResourceAttribute(objectNameTransactionMetrics_wildcard,
    			   "OpsStateLastChange",
    			   (void *) &time_value);
    if (rc != MF_SUCCESS) {
      printf("mfSetResourceAttribute (timevalue) for objectNameTransactionMetrics_wildcard failed rc %d\n",rc);
    }


    rc = mfSetResourceAttribute(objectNameTransactionMetrics_display,
    			   "OpsStateLastChange",
    			   (void *) &time_value); 
   if (rc != MF_SUCCESS) {
      printf("mfSetResourceAttribute (timevalue) for  objectNameTransactionMetrics_display failed rc %d\n",rc);
    }




   /* set the the availibility state */

    avail_value = AVAIL_NORMAL;
    mfSetResourceAttribute(objectNameInstrumStatus,
    			   "AvailabilityState",
    			   (void *) &avail_value);
    if (rc != MF_SUCCESS) {
      printf("mfSetResourceAttribute for objectNameInstrumStatus failed rc %d\n",rc);
    }


    rc = mfSetResourceAttribute(objectNameTransactionMetrics_login,
    			   "AvailabilityState",
    			   (void *) &avail_value);
    if (rc != MF_SUCCESS) {
      printf("mfSetResourceAttribute for objectNameTransactionMetrics_login failed rc %d\n",rc);
    }


    rc = mfSetResourceAttribute(objectNameTransactionMetrics_wildcard,
    			   "AvailabilityState",
    			   (void *) &avail_value);
    if (rc != MF_SUCCESS) {
      printf("mfSetResourceAttribute for objectNameTransactionMetrics_wildcard failed rc %d\n",rc);
    }


    rc = mfSetResourceAttribute(objectNameTransactionMetrics_display,
    			   "AvailabilityState",
    			   (void *) &avail_value); 
   if (rc != MF_SUCCESS) {
      printf("mfSetResourceAttribute for  objectNameTransactionMetrics_display failed rc %d\n",rc);
    }
    
  

   /* set the availability time */
   time_value = mfgetCurrentTimeMillis();
   mfSetResourceAttribute(objectNameInstrumStatus,
    			   "AvailStateLastChange",
    			   (void *) &time_value);
    if (rc != MF_SUCCESS) {
      printf("mfSetResourceAttribute (timevalue) for objectNameInstrumStatus failed rc %d\n",rc);
    }


    rc = mfSetResourceAttribute(objectNameTransactionMetrics_login,
    			   "AvailStateLastChange",
    			   (void *) &time_value);
    if (rc != MF_SUCCESS) {
      printf("mfSetResourceAttribute (timevalue) for objectNameTransactionMetrics_login failed rc %d\n",rc);
    }


    rc = mfSetResourceAttribute(objectNameTransactionMetrics_wildcard,
    			   "AvailStateLastChange",
    			   (void *) &time_value);
    if (rc != MF_SUCCESS) {
      printf("mfSetResourceAttribute (timevalue) for objectNameTransactionMetrics_wildcard failed rc %d\n",rc);
    }


    rc = mfSetResourceAttribute(objectNameTransactionMetrics_display,
    			   "AvailStateLastChange",
    			   (void *) &time_value); 
   if (rc != MF_SUCCESS) {
      printf("mfSetResourceAttribute (timevalue) for  objectNameTransactionMetrics_display failed rc %d\n",rc);
    }




   /* register and Instantiate transactionMetrics_display */
    rc = mfRegisterResourceMetrics(&resourceMetricsResource_circfile,
				   "CIRC_FILE",
				   &resourceMetrics_circfile,
				   80,
				   objectNameResourceMetrics_circfile);
    if (rc != MF_SUCCESS) {
      printf("mfRegisterResourceMetrics for  resourceMetricsResource_circfile failed rc %d\n",rc);
    }
    
    status_value = OPS_STARTING ;
    rc = mfSetResourceAttribute(objectNameResourceMetrics_circfile,
    			   "OperationalState",
    			   (void *) &status_value);
    
    if (rc != MF_SUCCESS) {
      printf("mfSetResourceAttribute for objectNameResourceMetrics_circfile  failed rc %d\n",rc);
    }


    
    NbOperations = 500 ;
    rc = mfSetResourceAttribute(objectNameResourceMetrics_circfile,
    			   "NbOperations",
    			   (void *) &NbOperations);
    
    if (rc != MF_SUCCESS) {
      printf("mfSetResourceAttribute for objectNameResourceMetrics_circfile (NbOperations) failed rc %d\n",rc);
    }




    /* create the discovery request */

    ProductName = "HTTPSERV_SRV";
    ProductInstance = (char *) malloc(20);
    bzero(ProductInstance,20);
    sprintf(ProductInstance,"HTTP_DEMO_%d",port);
    printf("ProductInstance %s\n", ProductInstance);
    sprintf(Uri,"%d",portNumber);
    printf("Uri ---> %s\n",Uri);
    rc = mfDiscoveryResponder(ProductName,ProductInstance,
				     Uri,
				     NULL);   
       
    if (rc != MF_SUCCESS) {
      printf("mfDiscoveryResponder failed\n");
    }



}



int main(int argc, char **argv)
{
    httpd *server;
    char *host;
    int	port, errFlag, result;
    extern char *optarg;
    extern int optind, opterr, optopt;
    int c;
    struct timeval timeout;
    int maxent;
    int maxdata;
    char path[80];
   

    host = NULL;
    port = 9090;
    errFlag = 0;
    while ( (c=getopt(argc,argv,"h:p:")) != -1 ) {
        switch ( c ) {
	case 'h':
	    host=optarg;
	    break;

	case 'p':
	    port = atoi(optarg);
	    printf("port number %d\n",port);
	    break;
	default:
	    errFlag++;
	}
    }
    if (errFlag) {
        fprintf(stderr,"usage: [-h <host IP>] [ -p <port >]\n");
	exit(1);
    }


    /*
     * Create a server and setup our logging
     */
    server = httpdCreate(host, port);
    if (server == NULL) {
        perror("Can't create server");
	exit(1);
    }
    httpdSetAccessLog(server, stdout);
    httpdSetErrorLog(server, stdout);

    /*
     * Setup some content for the server
     */
    httpdAddCContent(server,"/", "index.html", HTTP_TRUE, 
		     NULL, index_html);

    httpdAddCContent(server,"/", "enable.html", HTTP_FALSE, 
		     NULL, enable_html);
    httpdAddCContent(server,"/", "disable.html", HTTP_FALSE, 
		     NULL, disable_html);


    httpdAddCContent(server,"/", "enable_login.html", HTTP_FALSE, 
		     NULL, enable_login_html);
    httpdAddCContent(server,"/", "disable_login.html", HTTP_FALSE, 
		     NULL, disable_login_html);

    
    httpdAddCContent(server,"/", "enable_wildcard.html", HTTP_FALSE, 
		     NULL, enable_wildcard_html);
    httpdAddCContent(server,"/", "disable_wildcard.html", HTTP_FALSE, 
		     NULL, disable_wildcard_html);

    httpdAddCContent(server,"/", "enable_display.html", HTTP_FALSE, 
		     NULL, enable_display_html);
    httpdAddCContent(server,"/", "disable_display.html", HTTP_FALSE, 
		     NULL, disable_display_html);


     httpdAddCContent(server,"/", "enable_circfile.html", HTTP_FALSE, 
		     NULL, enable_circfile_html);
    httpdAddCContent(server,"/", "disable_circfile.html", HTTP_FALSE, 
		     NULL, disable_circfile_html);

    
    httpdAddStaticContent(server, "/", "test1.html", HTTP_FALSE,
			  NULL, test1_html);

    httpdAddCContent(server,"/", "display.html", HTTP_FALSE, 
		     NULL, display_html);
    httpdAddCContent(server,"/", "login.html", HTTP_FALSE,
		     NULL, login_html);

    httpdAddCContent(server,"/", "login2.html", HTTP_FALSE,
		     NULL, login2_html);
    httpdAddCWildcardContent(server,"/wildcard", NULL, wildcard_html);
    
     httpdAddCContent(server,"/", "display_circfile.html", HTTP_FALSE,
		     NULL, display_circfile);


    /* initiliase circular file */
    maxent = 1000;
    maxdata = 64*1024;
    
    strcpy(path,"/tmp/circ_file");
    if ((cf = circfile_open(strcmp(path, "-") == 0 ? NULL : path, 
			    0,
			    maxent, 
			    maxdata)) == NULL) {
	fprintf(stderr, "Error : %s", path);
    }



    /* initiliase MF */

    mfHttpdInit(port);


    

    /*
     * Go into our service loop
     */
    timeout.tv_sec = 5;
    timeout.tv_usec = 0;

    while(1 == 1) {
        result = httpdGetConnection(server, &timeout);
	if (result == 0) {
	  /*printf("Timeout ... \n"); */
	    continue;
	}
	if (result < 0) {
	    printf("Error ... \n");
	    continue;
	}
	if(httpdReadRequest(server) < 0) {
            httpdEndRequest(server);
	    continue;
	}
	httpdProcessRequest(server);
	httpdEndRequest(server);
    }
}
