/*
 * Copyright (c) 2004
 *
 */

/*
 *  httpd Private Header File
 */



#ifndef _HTTPD_PRIV_H
#define _HTTPD_PRIV_H 1

#ifdef __cplusplus
extern "C" {
#endif


#define	LEVEL_NOTICE	"notice"
#define LEVEL_ERROR	"error"

char * _httpd_unescape(char*);
char *_httpd_escape(char*);
char _httpd_from_hex (char);


void _httpd_catFile(httpd*, char*);
void _httpd_send403(httpd*);
void _httpd_send404(httpd*);
void _httpd_sendText(httpd*, char*);
void _httpd_sendFile(httpd*, char*);
void _httpd_sendStatic(httpd*, char*);
void _httpd_sendHeaders(httpd*, int,int);
void _httpd_sanitiseUrl(char*);
void _httpd_freeVariables(httpVar*);
void _httpd_formatTimeString(httpd*, char*, int);
void _httpd_storeData(httpd*, char*);
void _httpd_writeAccessLog(httpd*);
void _httpd_writeErrorLog(httpd*, char*, char*);


int _httpd_net_read(int, char*, int);
int _httpd_net_write(int, char*, int);
int _httpd_readBuf(httpd*, char*, int);
int _httpd_readChar(httpd*, char*);
int _httpd_readLine(httpd*, char*, int);
int _httpd_checkLastModified(httpd*, int);
int _httpd_sendDirectoryEntry(httpd*, httpContent*, char*);

httpContent *_httpd_findContentEntry(httpd*, httpDir*, char*);
httpDir *_httpd_findContentDir(httpd*, char*, int);

#endif  /* _HTTPD_PRIV_H */
