#!/usr/bin/ksh
#
# Script to update the CSM firmware patch with new firmware
#
GREP=/usr/bin/grep
SHOWREV=/usr/bin/showrev
LS=/usr/bin/ls
MV=/usr/bin/mv
CP=/usr/bin/cp
LN=/usr/bin/ln
RM=/usr/bin/rm
cur_dir=`/usr/bin/dirname $0`

patch_id=`${LS} | ${GREP} 117856`
if ! `${SHOWREV} -p | ${GREP} ${patch_id} > /dev/null`; then
    echo "Please install Sun StorEdge 6130 Management Host Software V 1.1 before executing this script"
    exit 1
fi

# Check for IOM-F
if [ -d ${patch_id}/IOM-F ]; then
    if [ -f ${patch_id}/IOM-F/baseline.txt ]; then # New firmware
        new_filename=`${LS} ${patch_id}/IOM-F | ${GREP} s3r | ${GREP} -v old`
        if [ -f /var/sadm/swimages/${patch_id}/IOM-F/baseline.txt ]; then # found old firmware
            old_filename=`${LS} /var/sadm/swimages/${patch_id}/IOM-F | ${GREP} s3r | ${GREP} -v old`
	    if [ ${old_filename} != ${new_filename} ]; then # Need to update
                ${MV} /var/sadm/swimages/${patch_id}/IOM-F/baseline.txt /var/sadm/swimages/${patch_id}/IOM-F/baseline.txt.old
                ${CP} ${patch_id}/IOM-F/baseline.txt /var/sadm/swimages/${patch_id}/IOM-F/baseline.txt
                ${MV} /var/sadm/swimages/${patch_id}/IOM-F/${old_filename} /var/sadm/swimages/${patch_id}/IOM-F/${old_filename}.old
		${CP} ${patch_id}/IOM-F/${new_filename} /var/sadm/swimages/${patch_id}/IOM-F
                ${RM} /var/sadm/swimages/${patch_id}/IOM-F/image.fw
		cd /var/sadm/swimages/${patch_id}/IOM-F
                ${LN} -s ${new_filename} image.fw
		cd ${cur_dir}
		echo "Install completed"
		echo "Please use Sun StorEdge 6130 Host Software V1.1 to upgrade your arrays"
 	    else
	        echo "Install completed"
		echo "Please use Sun StorEdge 6130 Host Software V1.1 to upgrade your arrays"
            fi
	fi
    fi
fi
