#!/usr/bin/perl
# 
# Copyright  2002 Sun Microsystems, Inc. All rights reserved. 
# 
# U.S. Government Rights - Commercial software. Government users are subject 
# to the Sun Microsystems, Inc. standard license agreement and applicable 
# provisions of the FAR and its supplements. 
#
# Use is subject to license terms. 
#
#----------------------------------------------------------------------
# This perl script is used to convert the SunAMCLientData service data  
# data in Access Manager 6.1 to that of the SunAMCLientData service in 
# Access Manager 2005Q1 
# The original the SunAMCLientData service data is assumed to be stored
# in file is61clientdata.ldif. The converted result will be stored in 
# file is62clientdata.ldif which can later be imported into Identity 
# Server 2005Q1 directory using ldapmodify. 
#


# open is61clientdata_int.ldif file for reading
open(IS61IDATA, "is61clientdata_int.ldif") || die "can't open listing of 6.1 data $!";

# open is61clientdata_ext.ldif file for reading
open(IS61EDATA, "is61clientdata_ext.ldif") || die "can't open listing of 6.1 data $!";

# open is62clientdata.ldif file for writing
open(IS62DATA, ">is62clientdata.ldif") || die "can't create ldif file for 2005Q1 data $!";

# open is62cleanup.ldif file for writing
open(CLEANUPDATA, ">is62cleanup.ldif") || die "can't create ldif file for 2005Q1 data $!";

$root_suffix = "";
$rdn="";
$firsttime="true";

# process the internal client data
while (<IS61IDATA>) {
    $line1 = $_;
    chomp($line1);

    # figure out the root suffix first
    if ($firsttime eq "true") {
        ($something, $root_suffix) = split (/ou=SunAMClientData\,ou=services\,/, $line1);     
        $firsttime="false";
    }

    ($attr1, $the_rest1) = split(/\:/, $line1);
    if ($attr1 eq "dn") {
        $the_rest1 =~ s/^ *//;
        ($rdn, $the_rest2) = split(/\,/, $the_rest1);
        if ($rdn ne "ou=internalData") {
            print IS62DATA "\n";
            print IS62DATA "dn: $rdn,ou=internalData,ou=1.0,ou=SunAMClientData,ou=ClientData,$root_suffix\n";
            print CLEANUPDATA "dn: $rdn,ou=internalData,ou=1.0,ou=SunAMClientData,ou=ClientData,$root_suffix\n";
            print CLEANUPDATA "changetype: delete\n\n";
            print IS62DATA "objectClass: top\n";
            print IS62DATA "objectclass: sunAMClient\n";
            $entryname = substr($rdn, 3);
            print IS62DATA "ou: $entryname\n"; 
        } 
    } elsif ($rdn ne "ou=internalData") {
        ($attr1, $the_rest1) = split(/\:/, $line1);
        if ($attr1 eq "sunkeyvalue") {
            $the_rest1 = substr($line1, 12);
            $the_rest1 =~ s/^ *//;
            if (index($the_rest1, "CcppAccept-Charset=GB18030") == -1) {
                ($attrname, $the_rest2) = split(/\=/, $the_rest1);
                $len = length($attrname);
                $attrvalue = substr($the_rest1, $len+1);
                print IS62DATA "sunamclient$attrname: $attrvalue\n";
            }
        }
    }
}

# process the external client data
while (<IS61EDATA>) {
    $line1 = $_;
    chomp($line1);

    # figure out the root suffix first
    if ($firsttime eq "true") {
        ($something, $root_suffix) = split (/ou=SunAMClientData\,ou=services\,/, $line1);     
        $firsttime="false";
    }

    ($attr1, $the_rest1) = split(/\:/, $line1);
    if ($attr1 eq "dn") {
        $the_rest1 =~ s/^ *//;
        ($rdn, $the_rest2) = split(/\,/, $the_rest1);
        if ($rdn ne "ou=externalData") {
            print IS62DATA "\n";
            print IS62DATA "dn: $rdn,ou=externalData,ou=1.0,ou=SunAMClientData,ou=ClientData,$root_suffix\n";
            print IS62DATA "objectClass: top\n";
            print IS62DATA "objectclass: sunAMClient\n";
            $entryname = substr($rdn, 3);
            print IS62DATA "ou: $entryname\n"; 
        } 
    } elsif ($rdn ne "ou=externalData") {
        ($attr1, $the_rest1) = split(/\:/, $line1);
        if ($attr1 eq "sunkeyvalue") {
            $the_rest1 = substr($line1, 12);
            $the_rest1 =~ s/^ *//;
            if (index($the_rest1, "CcppAccept-Charset=GB18030") == -1) {
                ($attrname, $the_rest2) = split(/\=/, $the_rest1);
                $len = length($attrname);
                $attrvalue = substr($the_rest1, $len+1);
                print IS62DATA "sunamclient$attrname: $attrvalue\n";
            }
        }
    }
}

close IS61IDATA;
close IS61EDATA;
close IS62DATA;
close CLEANUPDATA;

