/**
 * $Id: consolecomp.js,v 1.38 2004/07/26 19:49:54 jwn Exp $
 * Copyright  2004 Sun Microsystems, Inc. All rights reserved. 
 * 
 * Sun Microsystems, Inc. has intellectual property rights relating to
 * technology embodied in the product that is described in this document.
 * In particular, and without limitation, these intellectual property rights
 * may include one or more of the U.S. patents listed at
 * http://www.sun.com/patents and one or more additional patents or pending
 * patent applications in the U.S. and in other countries.
 * 
 * U.S. Government Rights - Commercial software. Government users are subject
 * to the Sun Microsystems, Inc. standard license agreement and applicable
 * provisions of the FAR and its supplements.
 * 
 * Use is subject to license terms. 
 * 
 * This distribution may include materials developed by third parties. Sun,
 * Sun Microsystems, the Sun logo, Java and Sun[tm] ONE are trademarks or
 * registered trademarks of Sun Microsystems, Inc. in the U.S. and other
 * countries. 
 * 
 * Copyright  2004 Sun Microsystems, Inc. Tous droits rservs. Sun
 * Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
 *  la technologie incorpore dans le produit qui est dcrit dans ce document.
 * En particulier, et ce sans limitation, ces droits de proprit
 * intellectuelle peuvent inclure un ou plus des brevets amricains lists
 *  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
 * ou les applications de brevet en attente aux Etats - Unis et dans les
 * autres pays.
 * 
 * L'utilisation est soumise aux termes du contrat de licence.
 * 
 * Cette distribution peut comprendre des composants dvelopps par des
 * tierces parties.
 * 
 * Sun, Sun Microsystems, le logo Sun, Java et Sun[tm] ONE sont des marques
 * de fabrique ou des marques dposes de Sun Microsystems, Inc. aux
 * Etats-Unis et dans d'autres pays.
 */

iplanet_console_disable_icon_after_click = false;

iplanet_console_selList = null;
iplanet_console_requiredList = null;
iplanet_console_passwordList = null;
iplanet_console_blankHTML = '../base/AMBlank';
iplanetDSAMEConsolePopUpName = 'dsamePopWin';
navItemArray = new Array();
navIconArray = new Array();
highlightColor = "#AAAACC";
unhighlightColor = "white";
unhighlightColor_pp = "#CCCCCC";
parentagePathLastNodeID = "dsame_pp";
parentagePathLastNodeIcon = "dsame_pp_icon";
navigationItem = "dsame_nav";
navigationIcon = "dsame_nav_icon";
highlightIcon = "../console/images/properties_disabled.gif";
propertiesIcon = "../console/images/properties.gif";
dsameNavSel = null;
dsameNavSelIcon = null;

trackArray = new Array();
trackMap = new Array();

if ((navigator.appName=="Netscape") && (document.getElementById == null)) {
    /*
     * This is to get Netscape 4.7x to convert div tag to layer tag
     * for highlight-able elements in the navigation frame.
     */
    document.write("<style>.highlightItem {position: relative} </style>");
}

function hrefSubmit(frmName, url, validate) {
    if (pageLoaded == 0) {
	return;
    }
    pageLoaded = 0;
    setTimeout("setPageLoaded()", 2000);

    var frm = document.forms[frmName];

    if (frm != null) {
	if (!validate || selBeforeSubmit()) {
	    var url = "?" + url;
	    var frmAction = frm.action;
	    var idx = frmAction.indexOf('?');

	    if (idx != -1) {
		frmAction = frmAction.substring(0, idx);
	    }

	    frm.action = frmAction + url;
	    frm.submit();
	}
    }
}

function formSubmit(frmName, action) {
    var frm = document.forms[frmName];

    if (frm != null) {
	frm.action = action;
	frm.submit();
    }
}

function setPageLoaded() {
    pageLoaded = 1;
}

function setPgSessionInHeaderFrame(pgSession) {
    var frmHeader = top.frames['headerFrame'];

    if (frmHeader != null) {
	setPgSessionInHeaderForm(
	    pgSession, frmHeader.document.forms['AMHeader']);
	setPgSessionInHeaderForm(
	    pgSession, frmHeader.document.forms['AMHeader1']);
    }
}

function setPgSessionInHeaderForm(pgSession, frm) {
    if (frm != null) {
	var elm = frm.elements['jato.pageSession'];
	if (elm != null) {
	    elm.value = pgSession;
	}
    }
}

/**
 * Set sub view tracking information in a hidden field in header and navigation
 * view.
 *
 * @param info  tracking information
 */
function setTrackingDataInHeaderNavFrame(info) {
    var frmHeader = top.frames['headerFrame'];
    if (frmHeader != null) {
	frmHeader.setTrackData(info,
	    frmHeader.getFormElement('AMHeader', 'AMHeader.fldTracking'));
    }

    var frmNavigation = top.frames['navigationFrame'];
    if (frmNavigation != null) {
	frmNavigation.setTrackData(info,
	    frmNavigation.getFormElementByName('fldTracking'));
    }
}

/**
 * set sub view tracking information in a hidden field
 *
 * @param info  tracking information
 * @param hiddenField  hidden field
 */
function setTrackData(info, hiddenField) {
    if (hiddenField == null) {
	return;
    }

    var idx = info.indexOf(':');
    if (idx != -1) {
	var key = info.substring(0, idx);
	var val = info.substring(idx+1);

	var found = 0;
	var size = trackArray.length;
	for (var i = 0; (i < size) && (found == 0); i++) {
	    if (trackArray[i] == key) {
		found = 1;
	    }
	}

	if (found == 0) {
	    trackArray[trackArray.length] = key;
	}
	trackMap[key] = val;

	// update tracking field
	var tmp = '';
	var size = trackArray.length;
	for (var i = 0; i < size; i++) {
	    var key = trackArray[i];
	    tmp += key + ':' + trackMap[key];

	    if (i != (size -1)) {
		tmp += '|';
	    }
	}

	hiddenField.value = tmp;
    }
}

function popUp(frmName, url) {
    var frm = document.forms[frmName];
    var attrib = "&jato.pageSession=" + frm.elements['jato.pageSession'].value;
    var url = "?" + url + attrib;
    url = frm.action + url;
    popUpWindow(url);
}

function popUpEx(frmName, url) {
    var frm = document.forms[frmName];
    var url = "?" + url;
    url = frm.action + url;
    popUpWindow(url);
}

function popUpWindow(url) {
    var bars = 'directories=no,location=0,menubar=0,status=0,titlebar=yes,toolbar=no';
    var options = 'scrollbars=yes,width=600,height=400,resizable=yes';
    var feature = bars + ',' + options;

    var openwin = window.open(url, iplanetDSAMEConsolePopUpName, feature);
    openwin.focus();
}

function closePopUpWindow() {
    var openwin = window.open('', iplanetDSAMEConsolePopUpName, 'width=0;height=0');
    openwin.close();
}

function removeSelFromList(frmName, ListName) {
    var frm = document.forms[frmName];

    if (frm != null) {
	var list = frm.elements[ListName];

	if (list != null) {
	    var optList = list.options;
	    var size = optList.length;

	    for (var i = size-1; i >= 0; --i) {
		var opt = optList[i];
		if ((opt.selected) && (opt.value != "")) {
		    optList[i] = null;
		}
	    }
	}
    }
}

function addToList(frmName, TextBoxName, ListName) {
    var frm = document.forms[frmName];

    if (frm != null) {
	var list = frm.elements[ListName];
	var box = frm.elements[TextBoxName];

	if ((list != null) && (box != null)) {
	    var OptList = list.options;
	    var str = box.value;
	    str = strTrim(str);

            if (str.length > 0) {
                var size = OptList.length;
                var txt = OptList[size-1].text;
                var val = OptList[size-1].value;
                // move the separator to end of list
                OptList[size] = new Option(txt,val);

                // add the new entry where the separator was
                OptList[size-1].text = str;
                OptList[size-1].value = str;

                // de-select the previously selected items
                OptList.selectedIndex = -1;
                // now select the new entry
                OptList.selectedIndex = size-1;
            }
	}
    }
}

function moveToList(frmName, frListName, toListName, keep) {
    var frm = document.forms[frmName];
    if (frm == null) {
	return;
    }

    var frList = frm.elements[frListName];
    var toList = frm.elements[toListName];

    if ((frList != null) && (toList !=null)) {
	var optList = frList.options;
	var toListOptList = toList.options;
	var size = optList.length;

	for (var i = size-1; i >= 0; --i) {
	    var opt = optList[i];

	    if (opt.selected) {
		toListOptList[toListOptList.length] 
		    = new Option(opt.text, opt.value);

		if ((keep != null) && (!keep)) {
		    optList[i] = null;
		}
	    }
	}
    }
}

function moveToTextBox(frmName, frListName, toBoxName) {
    var frm = document.forms[frmName];
    if (frm == null) {
	return;
    }

    var frList = frm.elements[frListName];
    var toBox = frm.elements[toBoxName];

    if ((frList != null) && (toBox !=null)) {
	var optList = frList.options;
	var size = optList.length;

	for (var i = size-1; i >= 0; --i) {
	    var opt = optList[i];

	    if (opt.selected) {
		toBox.value = opt.value;
	    }
	}
    }
}

function selBeforeSubmit() {
    selListItems();

    return matchPassword() && checkRequiredFields();
}

function selListItems() {
    if (iplanet_console_selList != null) {
	var size = iplanet_console_selList.length;

	for (var i = 0; i < size; i++) {
	    var frmElm = iplanet_console_selList[i];
	    var elm = getFormElm(frmElm.frmName, frmElm.elementName);

	    if (elm != null) {
		selAllOptions(elm);
	    }
	}
    }
}

function matchPassword() {
    if (iplanet_console_passwordList != null) {
	var size = iplanet_console_passwordList.length;

	for (var i = 0; i < size; i++) {
	    var frmElm = iplanet_console_passwordList[i];
	    var pwdElm = getFormElm(frmElm.frmName, frmElm.pwdName);
	    var confirmElm = getFormElm(frmElm.frmName, frmElm.confirmName);

	    if ((pwdElm != null) && (confirmElm!= null)) {
		if (pwdElm.value != confirmElm.value) {
		    alert(frmElm.message);
		    return false;
		}
	    }
	}
    }
    return true;
}

function checkRequiredFields() {
    if (iplanet_console_requiredList != null) {
	var size = iplanet_console_requiredList.length;

	for (var i = 0; i < size; i++) {
	    var frmElm = iplanet_console_requiredList[i];
	    var elm = getFormElm(frmElm.frmName, frmElm.elementName);

	    if ((elm != null) && !hasValue(elm)) {
		alert(frmElm.message);
		return false;
	    }
	}
    }
    return true;
}

function addToRequiredFieldArray(frmName, elementName, message) {
    if (iplanet_console_requiredList == null) {
	iplanet_console_requiredList = new Array();
    }
    iplanet_console_requiredList[iplanet_console_requiredList.length]
	= new requiredElement(frmName, elementName, message);
}

function addToPasswordConfirmFieldArray(frmName, pwdName, pwdConfirmName,
    message) {
    if (iplanet_console_passwordList == null) {
	iplanet_console_passwordList = new Array();
    }
    iplanet_console_passwordList[iplanet_console_passwordList.length]
	= new passwordElement(frmName,  pwdName, pwdConfirmName, message);
}

function addToSelBeforeSubmitArray(frmName, elementName) {
    if (iplanet_console_selList == null) {
	iplanet_console_selList = new Array();
    }
    iplanet_console_selList[iplanet_console_selList.length]
	= new frmElement(frmName, elementName);
}

function getFormElm(frmName, elementName) {
    var frm = document.forms[frmName];
    if (frm != null) {
	return frm.elements[elementName];
    }
    return null;
}

function hasValue(elm) {
    var type = elm.type;

    if ((type == 'select-one') || (type == 'select-multiple')) { // is list box
	return hasOptionSelected(elm);
    } else {
	var val = elm.value;
	val = strTrim(val);
	return (val.length > 0);
    }
}

function hasOptionSelected(elm) {
    var optList = elm.options;
    var size = optList.length;

    for (var i = 0; i < size; i++) {
	if ((optList[i].selected) && (optList[i].value != "")) {
	    return true;
	}
    }
    return false;
}

function selAllOptions(ListElm) {
    var optList = ListElm.options;
    var size = optList.length;

    for (var i = 0; i < size; i++) {
	if (optList[i].value != "") {
	    optList[i].selected = true;
	}
    }
}

function requiredElement(frmName, elementName, message) {
    this.frmName = frmName;
    this.elementName = elementName;
    this.message = message;
}

function passwordElement(frmName, pwdName, confirmName, message) {
    this.frmName = frmName;
    this.pwdName = pwdName;
    this.confirmName = confirmName;
    this.message = message;
}

function frmElement(frmName, elementName) {
    this.frmName = frmName;
    this.elementName = elementName;
}

function selAllCheckBoxes(frmName, state, tiledName) {
    var frm = document.forms[frmName];
    if (frm != null) {
	if (tiledName) {
	    tiledName += '[';
	}

	var size = frm.elements.length;

	for (var i = 0; i < size; i++) {
	    var elm = frm.elements[i];
	    var type = elm.type;

	    if (type != null) {
		var strType = new String('' + type);
		strType = strType.toLowerCase();

		if (strType == "checkbox") {
		    if ((tiledName == null) ||
			(elm.name.indexOf(tiledName) != -1)
		    ) {
			elm.checked = (state) ? true : "";
		    }
		}
	    }
	}
    }
}

function strTrim(str){
    return str.replace(/^\s+/,'').replace(/\s+$/,'')
}

function resetPage(formName) {
    var pageForm = document.forms[formName];
    if (pageForm != null) {
        pageForm.reset();
    }
} 

/**
 * invokes a view bean using url on a targeted frame
 * we append random string to the url to fix IE reloading
 * problem, append a dummy command, <viewbean>.g=, and
 * we added page session attribute. The view bean needs
 * to extends from com.iplanet.am.console.base.AMViewBeanBase
 *
 * @param target - targetted frame
 * @param url - url to invoke view bean
 * @param randomStr - random string
 * @param pgSession - page session attribute string
 */
function invokeVB(target, url, randomStr, pgSession) {
    if (target != null) {
	url = sanitizeViewBeanURL(url);
	var vbName = getViewBeanName(url);
	url += '.' + randomStr + '?' +  vbName + '.g=';
	url += '&jato.pageSession=' + pgSession;
	target.location = url;
    }
}

/**
 * sanitizes url of a view bean
 *
 * @return sanitized url
 */
function sanitizeViewBeanURL(url) {
    var idx = url.lastIndexOf('.jsp');

    if (idx != -1) {
        url = url.substring(0, idx);
    }

    return url;
}

/**
 * gets name of view bean 
 *
 * @return name of view bean
 */
function getViewBeanName(url) {
    var idx = url.lastIndexOf('/');

    if (idx != -1) {
	url = url.substring(idx +1);
    }

    return url;
}

/**
 * checks no escape characters
 *
 * @param frmName - form name
 * @param elmName - element name
 * @param msg - message
 * @return true if there are no escape character in field element
 *         false if there are escape character and popup a alert box
 *         with msg
 */
function checkEscapeCharInName(frmName, elmName, msg) {
    var hasEscapeChar = false;
    var frm = document.forms[frmName];

    if (frm != null) {
	var elm = frm.elements[elmName];

	if ((elm != null) && (elm.value.indexOf('\\') != -1)) {
	    alert(msg);
	    hasEscapeChar = true;
	}
    }
    return !hasEscapeChar;
}

/**
 * checks no double quote characters
 *
 * @param frmName - form name
 * @param elmName - element name
 * @param msg - message
 * @return true if there are no double quote character in field element
 *         false if there are double quote character and popup a alert box
 *         with msg
 */
function checkDblQuoteCharInName(frmName, elmName, msg) {
    var hasDblQuote = false;
    var frm = document.forms[frmName];

    if (frm != null) {
        var elm = frm.elements[elmName];

        if ((elm != null) && (elm.value.indexOf('"') != -1)) {
            alert(msg);
            hasDblQuote = true;
        }
    }
    return !hasDblQuote;
}

/**
 * checks no comma characters
 *
 * @param frmName - form name
 * @param elmName - element name
 * @param msg - message
 * @return true if there are no comma character in field element
 *         false if there are comma character and popup a alert box
 *         with msg
 */
function checkCommaCharInName(frmName, elmName, msg) {
    var hasComma = false;
    var frm = document.forms[frmName];

    if (frm != null) {
        var elm = frm.elements[elmName];

        if ((elm != null) && (elm.value.indexOf(',') != -1)) {
            alert(msg);
            hasComma = true;
        }
    }
    return !hasComma;
}

/**
 * copies string from a selected option in select list to a text box
 *
 * @param selectList - select list object
 * @param textBoxName - name of text box
 */
function copyOptionToTextBox(selectList, textBoxName) {
    var frm = selectList.form;

    if (frm != null) {
        var textBox = frm.elements[textBoxName];

        if (textBox != null) {
            var idx = selectList.selectedIndex;
            if ((idx != null) && (idx >= 0)) {
                textBox.value = selectList.options[idx].value;
            }
        }
    }
}

/**
 * deselects all options in the list
 *
 * @param list object
 */
function deselectAll(list)  {
    var options = list.options;

    if (options != null) {
	var len = options.length;

	for (var i = 0; i < len; i++) {
	    options[i].selected = false;
	}
    }
}

/**
 * shifts the selected item one level down
 *
 * @param formName - name of form
 * @param elmName - name of select object
 * @param msgMoreThanOneSelect - alert message if more than one option is
 *        selected
 */
function shiftDown(formName, elmName, msgMoreThanOneSelect)  {
    var elm = getFormElement(formName, elmName);

    if (elm != null) {
	if (hasMoreThanOneOptionSelected(elm.options)) {
	    if ((msgMoreThanOneSelect != null) &&
		(msgMoreThanOneSelect != "")) {
		alert(msgMoreThanOneSelect);
	    }
	} else {
	    var idx = elm.selectedIndex;
	    var last = elm.options.length-1;

	    if (elm.options[last].value == '') {
		last--;
	    }
	    
	    if ((idx != -1) && (idx < last) && (elm.options[idx].value != '')) {
		deselectAll(elm);
		swapOptionValuesAndLabels(elm, idx, idx+1);
		elm.options[idx+1].selected = true;
	    }
	}
    }
}

/**
 * shifts the selected item one level up
 *
 * @param formName - name of form
 * @param elmName - name of select object
 * @param msgMoreThanOneSelect - alert message if more than one option is
 *        selected
 */
function shiftUp(formName, elmName, msgMoreThanOneSelect) {
    var elm = getFormElement(formName, elmName);

    if (elm != null) {
	if (hasMoreThanOneOptionSelected(elm.options)) {
	    if ((msgMoreThanOneSelect != null) && 
		(msgMoreThanOneSelect != "")) {
		alert(msgMoreThanOneSelect);
	    }
	} else {
	    var idx = elm.selectedIndex;
	    
	    if ((idx != -1) && (idx > 0) && (elm.options[idx].value != '')) {
		deselectAll(elm);
		swapOptionValuesAndLabels(elm, idx-1, idx);
		elm.options[idx-1].selected = true;
	    }
        }
    }
}

/**
 * swaps value and label of two options in a list element
 *
 * @param elm - list element
 * @param idx1 - index of first option
 * @param idx2 - index of second option
 */
function swapOptionValuesAndLabels(elm, idx1, idx2) {
    var text = elm.options[idx1].text;
    var value = elm.options[idx1].value;
    elm.options[idx1].text = elm.options[idx2].text;
    elm.options[idx1].value = elm.options[idx2].value;
    elm.options[idx2].text = text;
    elm.options[idx2].value = value;
}

/**
 * determine if more than one option is selected
 *
 * @param options collection
 * @return true if more than one option is selected
 */
function hasMoreThanOneOptionSelected(options) {
    var count = 0;
    var len = options.length;

    for (var i = 0; (i < len) && (count < 2); i++) {
	if (options[i].selected) {
	    count++;
	}
    }

    return (count > 1);
}


/**
 * gets form element
 *
 * @param frmName - name of form
 * @param elmName - name of element
 * @return form element object
 */
function getFormElement(frmName, elmName) {
    var elm = null;
    var frm = document.forms[frmName];

    if (frm != null) {
	elm = frm.elements[elmName];
    }

    return elm;
}

/**
 * Get form element by element name
 *
 * @param elmName - name of element
 * @return form element object
 */
function getFormElementByName(elmName) {
    var forms = document.forms;
    for (var i = 0; i < forms.length; i++) {
	var frm = forms[i];
	var elements = frm.elements;

	for (var j = 0; j < elements.length; j++) {
	    var elm = elements[j];
	    var eName = elm.name;
	    var idx = eName.indexOf(".");

	    if (idx != -1) {
		eName = eName.substring(idx+1);
	    }

	    if (eName == elmName) {
		return elm;
	    }
	}
    }
    return null;
}

/** clear data frame */
function clearDataView() {
    var dataFrame = top.frames.dataFrame;

    if (dataFrame != null) {
	dataFrame.location = iplanet_console_blankHTML;
    }
}

/**
 * submits a form when a hyperlink in parentage path is clicked
 *
 * @param frmName - name of form to submit
 * @param elmName - parentage path element name
 * @param value of hyperlink
 */
function parentagePathSubmit(frmName, elmName, value) {
    if ((value != null) && (value != '')) {
	clearDataView();
	var frm = document.forms[frmName];
	frm.elements[elmName].value = value;
	frm.submit();
    }
}

/**
 * highlights selected item in navigation view
 *
 * @param idx - index of item to highlight
 */
function highlightNavItem(idx) {
    return highlight(navigationItem + idx, navigationIcon + idx);
}

/**
 * highlights selected item in navigation view
 *
 * @param name of selected item
 * @param imgName - image ID/Name of selected item
 */
function highlight(name, imgName) {

    if (iplanet_console_disable_icon_after_click &&
        (dsameNavSelIcon != null) &&
	(dsameNavSelIcon.name == imgName)
    ) {
	return false;
    }

    if (document.layers) {
	if (dsameNavSel != null) {
	    dsameNavSel.document.bgColor =
		(dsameNavSel.name == parentagePathLastNodeID) ?
		unhighlightColor_pp : unhighlightColor;
	}
	if (name != null) {
	    dsameNavSel = document.layers[name];
	    if (dsameNavSel != null) {
		dsameNavSel.document.bgColor = highlightColor;
	    }
	}
    } else if (document.all) {
	if (dsameNavSel != null) {
	    dsameNavSel.style.background = "";
	}
	if (name != null) {
	    dsameNavSel = document.all[name];
	    if (dsameNavSel != null) {
		if (dsameNavSel.length) {
		    dsameNavSel = dsameNavSel[dsameNavSel.length-1];
		}
		dsameNavSel.style.background = highlightColor;
	    }
	}
    } else {
	if (dsameNavSel != null) {
	    dsameNavSel.style.background =
		(dsameNavSel.id == parentagePathLastNodeID) ?
		unhighlightColor_pp : unhighlightColor;
	}
	if (name != null) {
	    dsameNavSel = document.getElementById(name);
	    if (dsameNavSel != null) {
		dsameNavSel.style.background = highlightColor;
	    }
	}
    }

    if (iplanet_console_disable_icon_after_click) {
	if (dsameNavSelIcon != null) {
	    dsameNavSelIcon.src = propertiesIcon;
	    dsameNavSelIcon = null;
	}

	if (imgName != null) {
	    dsameNavSelIcon = document.images[imgName];

	    if (dsameNavSelIcon != null) {
		dsameNavSelIcon.src = highlightIcon;
	    }
	}
    }

    return true;
}

/**
 * highlights selected item in navigation view
 *
 * @param name of selected item
 */
function highlightByName(name) {
    var itemName = navItemArray[name];
    var itemIcon = navIconArray[name];

    if (itemName != null) {
	return highlight(itemName, itemIcon);
    }

    return false;
}

/**
 * opens name-value list view
 *
 * @param frmName - name of form
 * @param elmName - name of list element
 * @param lblName - label of attribute
 * @param type of operation either add, edit or copy
 */
function openNameValueList(frmName, elmName, lblName, type) {
    var frm = document.forms[frmName];
    var elm = frm.elements[elmName];
    var values = "";

    if (type != "add") {
	var optList = elm.options;

	for (var i = 0; (i < optList.length) && (values == ""); i++) {
	    if ((optList[i].selected) && (optList[i].value != "")) {
		values = optList[i].value;
	    }
	}
    }

    if ((type == "add") || (values != "")) {
	openNameValueWin();
	var frmSubmit = document.forms['frmNameValue'];

	if (frmSubmit != null) {
	    frmSubmit.elements['l'].value = lblName;
	    frmSubmit.elements['n'].value = elmName;
	    frmSubmit.elements['f'].value = frmName;
	    frmSubmit.elements['t'].value = type;
	    frmSubmit.elements['e'].value = values;
	    frmSubmit.submit();
	}
    }
}

/**
 * opens borderless window for name-value list
 *
 * @param url of the name value list view bean
 */
function openNameValueWin() {
    var bars = 'directories=no,location=0,menubar=0,status=0,titlebar=yes,toolbar=no';
    var options = 'scrollbars=yes,width=550,height=350,resizable=yes';
    var feature = bars + ',' + options;

    var openwin = window.open(iplanet_console_blankHTML,
	iplanetDSAMEConsolePopUpName, feature);
    openwin.focus();
}

/**
 * adds entry to name value list in data frame
 *
 * @param frmName - name of HTML form
 * @param attrName - name of HTML List element
 * @param value to be added
 */
function addNameValueAttr(frmName, attrName, value) {
    var frm = document.forms[frmName];
    var elm = frm.elements[attrName];
    var OptList = elm.options;

    var size = OptList.length;
    var txt = OptList[size-1].text;
    var val = OptList[size-1].value;

    // move the separator to end of list
    OptList[size] = new Option(txt,val);
    
    // add the new entry where the separator was
    OptList[size-1].text = value;
    OptList[size-1].value = value;
    
    // de-select the previously selected items
    OptList.selectedIndex = -1;
    // now select the new entry
    OptList.selectedIndex = size-1;
}

/**
 * updates name-value entries in data frame
 *
 * @param frmName - name of HTML form
 * @param attrName - name of HTML List element
 * @param oldValue - previous value
 * @param value - new value
 */
function updateNameValueAttr(frmName, attrName, oldValue, value) {
    var frm = document.forms[frmName];
    var elm = frm.elements[attrName];
    var found = false;
    var optList = elm.options;

    optList.selectedIndex = -1;
    for (var i = 0; (i < optList.length) && !found; i++) {
        if (optList[i].value == oldValue) {
            optList[i].value = value;
            optList[i].text = value;
            optList[i].selected = true;
            found = true;
        }
    }
}

/**
 * moves options from one list to another
 *
 * @param formName - name of form
 * @param fromList - list from which options resides
 * @param tolist - destinated list
 * @param moveAll - true to move all options fromList to toList
 */
function moveListOption(formName, fromList, toList, moveAll) {
    var frm = document.forms[formName];
    var from = frm.elements[fromList];
    var to = frm.elements[toList];

    for (var i = from.options.length -1; i >= 0; --i) {
	if (from.options[i].value != '') {
	    if ((moveAll) || (from.options[i].selected)) {
		moveOption(from, to, i);
	    }
	}
    }
}

/**
 * moves option from one list to another
 *
 * @param fromList - list from which options resides
 * @param tolist - destinated list
 * @param idx - index of option in fromList to be moved
 */
function moveOption(fromList, toList, idx) {
    var size = toList.options.length;
    toList.options[size] =
	new Option(toList.options[size-1].text, toList.options[size-1].value);
    toList.options[size-1].text = fromList.options[idx].text;
    toList.options[size-1].value = fromList.options[idx].value;
    fromList.options[idx] = null;
}

/**
 * determines if page is completely loaded
 *
 * @return true if page is completely loaded
 */
function isPageCompletelyLoad() {
    if ((pageLoaded) && (pageLoaded == 1)) {
	return true;
    } else {
	return false;
    }
}

/**
 * enable select tag and set onchange event handle
 *
 * @param frmName - name of form
 * @param elmName - name of element
 * @param evtHandler - onchange event handler
 */
function enableSelectEx(frmName, elmName, evtHandler) {
    var frm = document.forms[frmName];

    if (frm) {
	var elm = frm.elements[elmName];

	if (elm) {
	    elm.onfocus = new Function();
	    elm.disabled = false;
	    elm.onchange = evtHandler;
	}
    }
}

/**
 * disable select tag
 *
 * @param frmName - name of form
 * @param elmName - name of element
 */
function disableSelect(frmName, elmName) {
    var frm = document.forms[frmName];
    var elm = frm.elements[elmName];

    if (!document.all) {
	elm.onfocus = new Function("blur(this);");
    }
    
    elm.disabled = true;
}

/**
 * Updates the peer component of checkbox array component.
 * This is used by CheckboxArray tag.
 */
function updateCheckBoxPeer(formName, peerName, value, bAdd) {
    var frm = document.forms[formName];

    if (frm != null) {
	var peer = frm.elements[peerName];

	if (peer != null) {
	    if (bAdd) {
		if (peer.value == '') {
		    peer.value = value;
		} else {
		    peer.value += '|' + value;
		}
	    } else {
		if (peer.value == value) {
		    peer.value = '';
		} else {
		    var str = '|' + value + '|';
		    var idx = peer.value.indexOf(str);

		    if (idx != -1) {
			peer.value = peer.value.substring(0, idx+1) +
			    peer.value.substring(idx + str.length);
		    } else {
			str = value + '|';
			idx = peer.value.indexOf(str);

			if (idx != -1) {
			    peer.value = peer.value.substring(idx + str.length);
			} else {
			    str = '|' + value;
			    idx = peer.value.indexOf(str);

			    if (idx != -1) {
				peer.value = peer.value.substring(0, idx);
			    }
			}
		    }
		}
	    }
	}
    }
}
