#!/bin/sh
# Copyright 2005 Sun Microsystems, Inc. All Rights Reserved.
#pragma ident  "@(#)restart_picld.sh  1.4   05/05/05 SMI"

# restart the picld daemon by fully killing it and 
# then starting it again, using the same script as 
# in /etc/init.d/picld. For solaris 10 we use svcadm.

PLATFORM=`uname -i`
OS_RELEASE=`/usr/bin/uname -r | sed 's/^5/2/' | cut -d\. -f1,2`

if [ $PLATFORM = 'SUNW,Sun-Fire-280R' ]; then

  if [ $OS_RELEASE = '2.10' ]; then

    /usr/sbin/svcadm restart svc:/system/picl

  else

    status=`ps -ef | grep picld | grep -v grep |  wc -l `
  
    if [ $status -ge 1 ]; then
      /etc/init.d/picld stop ; sleep 1	# stop it once.
      status=`ps -ef | grep picld | grep -v grep | wc -l `
      if [ $status -ge 1 ]; then
        /etc/init.d/picld stop		# stop it again if it still exists.
        sleep 1
      fi
    fi
  
    /etc/init.d/picld start

  fi

fi
