/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

package samples.mqfailover.ejb;

import java.rmi.RemoteException;

import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;

import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;

import javax.naming.Context;
import javax.naming.InitialContext;

import javax.swing.JOptionPane;

/**
 * A simple MDB attached to the ReplyQueue to demonstrate that messages are delivered inspite
 * of MQ broker/MDB failover
 * @author Sivakumar Thyagarajan
 */
public class MQFailoverTestReplyMDB implements MessageDrivenBean, MessageListener {

    private Context context;
    private TopicConnectionFactory factory;
    private Topic replyTopic;

    
    public void ejbCreate() throws RemoteException {
            System.out.println("MQFailoverTestReplyMDB :: ejbCreate()");
    }

    public void setMessageDrivenContext(MessageDrivenContext newMDC) {
    	System.out.println(" MQFailoverTestReplyMDB : setMDC");
    }

    public void ejbRemove() {
    	System.out.println(" MQFailoverTestReplyMDB : ejbRemove");
    }

    public void onMessage(Message msg) {
        System.out.println("MQFailoverTestReplyMDB: onMessage - Message being " + 
                           "delivered to MDB is:  " + msg);

        try {
            System.out.println("**** MQFailoverTestReplyMDB: Message Text received" + 
                               ((TextMessage)msg).getText()); 

            JOptionPane.showConfirmDialog(null, "Reply received :: " + ((TextMessage)msg).getText(), 
        				"JMS Failover sample - reply received", 
        				JOptionPane.DEFAULT_OPTION, 
        				JOptionPane.INFORMATION_MESSAGE);
        } catch(Exception ex) {
            System.out.println("MQFailoverTestMDB: onMessage: exception " + ex.getMessage());
            ex.printStackTrace();
        } 
    } 
}
