/*
 *    mig_rearch.c
 *
 * Program to force a rearchive of third-party files.
 *
 */

/*
 *    LSC_disclaimer_begin
 *
 *  Copyright (c) 2003 Sun Microsystems, Inc.
 *  All rights reserved.
 *
 *  This file is a product of Sun Microsystems, Inc. and is provided for
 *  unrestricted use provided that this header is included on all media
 *  and as a part of the software program in whole or part.  Users may
 *  copy, modify or distribute this file at will.
 *
 *  This file is provided with no support and without any obligation on
 *  the part of Sun Microsystems, Inc. to assist in its use, correction,
 *  modification or enhancement.
 *
 *  THIS FILE IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING
 *  THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 *  PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 *  SUN MICROSYSTEMS INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 *  INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY THIS FILE
 *  OR ANY PART THEREOF.
 *
 *  IN NO EVENT WILL SUN MICROSYSTEMS, INC. BE LIABLE FOR ANY LOST REVENUE
 *  OR PROFITS OR OTHER SPECIAL, INDIRECT AND CONSEQUENTIAL DAMAGES, EVEN
 *  IF THEY HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 *
 *  Sun Microsystems, Inc.
 *
 *    LSC_disclaimer_end
 */


#ifndef lint
static char rcs_id[] = "@(#)$Id: mig_rearch.c,v 1.6 2004/09/29 21:14:54 rh27482 Exp $";
#endif /* lint */
#pragma ident "$Id: mig_rearch.c,v 1.6 2004/09/29 21:14:54 rh27482 Exp $"

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <syslog.h>
#include <unistd.h>
#include <errno.h>
#include <fcntl.h>
#include <dirent.h>
#include <ndbm.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "pub/mig.h"

void
main(int argc, char *argv[])
{
	int count, i;
	char **vsn_list;

	if (argc < 4) {
		fprintf(stderr, "Usage: mig_rearch sam-fs media-type vsn-list\n");
		fprintf(stderr, "example:  mig_rearch /sam za cdrom0\n");
		exit(1);
	}

	/* peel off the list of VSNs */
	vsn_list = (char **) malloc(sizeof (char *) * (argc - 3 + 1));
	for (i = 3; i < argc; i++)
		vsn_list[i - 3] = argv[i];
	vsn_list[i - 3] = NULL;

	count = sam_mig_rearchive(argv[1], vsn_list, argv[2]);
	if (count < 0) {
		fprintf(stderr, "rearchive failed: %s\n", strerror(errno));
		exit(1);
	}
	exit(0);
}
