/*
 * PROPRIETARY/CONFIDENTIAL. Use of this product is subject to license terms.
 * Copyright 2003 Sun Microsystems, Inc. All rights reserved.
 */

var hostDomainEnabled = false;
var hostDomain = null;
var shareListFtp = null;
var shareListNetware = null;
var shareListNfs = null;
var shareListWin = null;
var initURL = null;

function initializeAll() {
	//handleHostTypeChanged();
	//initShareList(); // Select the first entry
	saveShareList();
	handleHostTypeChanged();
	initShareList(); // Select the first entry	
}

function selectListBoxes() {
	addToSelBeforeSubmitArray(formName, hostsharelist);
	selBeforeSubmit();
}

function _isDigit (c) {
		return ((c >= "0") && (c <= "9"));
}

function _isLetter (c) {
		return ( ((c >= "a") && (c <= "z")) || ((c >= "A") && (c <= "Z")) )
}


function _isInteger(s) {
	for (i = 0; i < s.length; i++) {
		var c = s.charAt(i);
		if (!_isDigit(c))
				return false;
	}
	return true;
}

function _validateShareValues() {
/*
	var sname = document.forms[formName].elements[hostsharename].value;
	var suser = document.forms[formName].elements[hostshareuser].value;
	var spass = document.forms[formName].elements[hostsharepass].value;

	if (sname.length == 0 || suser.length == 0 || spass.length == 0) {
			alert(errorMessages['emptyFields']);
			return false;
	}

	if (!_isLetter(suser.charAt(0))) {
			alert(errorMessages['invalidshareuser']);
			return false;
	}
*/
	return true;
}

function addToShareList() {
	var sname = document.forms[formName].elements[hostsharename].value;
	var spassword = null;
	if( document.forms[formName].elements[hostsharepassword].disabled == false ) {
            spassword = document.forms[formName].elements[hostsharepassword].value;
	}
	var svalue;
	if( spassword == null || spassword == "") {
	    svalue = sname;
	} else {
	    svalue = sname + "\n" + spassword;
	}
	/*
	 * Check for duplicates and then validate entries
	 */
	for (var i = 0; i < document.forms[formName].elements[hostsharelist].options.length; i++) {
		var cur = document.forms[formName].elements[hostsharelist].options[i];
		currentshare = cur.value;
		var currentsharearray = currentshare.split("\n");
		var currentsharename = currentsharearray[0];
		if (currentsharename == sname) {
			alert(errorMessages['duplicateshares']);
			return;
		}
	}
	if (_validateShareValues()) {
		var sharelistlength = document.forms[formName].elements[hostsharelist].length;
		var opt = new Option(sname, svalue);
		document.forms[formName].elements[hostsharelist].options[sharelistlength] = opt;
		document.forms[formName].elements[hostsharename].value = "";
		document.forms[formName].elements[hostsharepassword].value = "";
	}
	saveShareList();
}

/*
 * Deletes the selected entries from the Share list
 */
function deleteFromShareList() {
	for (var i = 0; i < document.forms[formName].elements[hostsharelist].length; i++) {
		var opt = document.forms[formName].elements[hostsharelist].options[i];

		if ( (opt.selected) && (opt.value != "") ) {
			document.forms[formName].elements[hostsharelist].options[i] = null;
			if (document.forms[formName].elements[hostsharelist].length > 0) {
				i--;
			}
		}
	}
	saveShareList();
    //document.forms[formName].elements[hostsharename].value = "";
    //document.forms[formName].elements[hostsharepassword].value = "";
}

/*
 * Put the selected Share name, Share username, and Share password
 * into the appropriate input widgets
 */

function editShareSelected() {
	var selectedshare = "";

	for (var i = 0; i < document.forms[formName].elements[hostsharelist].options.length; i++) {
		var opt = document.forms[formName].elements[hostsharelist].options[i];
		if (opt.selected) {
			selectedshare = opt.value;
		}
	}
	if ( (selectedshare == null) || (selectedshare == "") ) {
		document.forms[formName].elements[hostsharename].value = "";
		document.forms[formName].elements[hostsharepassword].value = "";
		return;
	}
	var selectedshares = selectedshare.split("\n");
	document.forms[formName].elements[hostsharename].value = selectedshares[0];
	
	if(selectedshares.length == 2) {
	    if(document.forms[formName].elements[hostsharepassword].disabled == false) {
	        document.forms[formName].elements[hostsharepassword].value = selectedshares[1];
	    }
	} else {
	    document.forms[formName].elements[hostsharepassword].value = "";
	}
	
}

function initShareList() {
	for (var i=0; i < document.forms[formName].elements[hostsharelist].options.length; i++) {
		document.forms[formName].elements[hostsharelist].options[i].selected = false;
	}
	if (document.forms[formName].elements[hostsharelist].options[0] != null &&
	   document.forms[formName].elements[hostsharelist].options[0].value != "" ) {
		document.forms[formName].elements[hostsharelist].options[0].selected = true;
		editShareSelected();
	}
}

/*
 * Checks whether the given field exists in the form or not
 */
function fieldExists(fieldName) {
	var field = document.forms[formName].elements[fieldName];
	if ( field == null || (typeof field == "undefined"))
		return false;
	return true;
}
/*
 * Returns false if the value in the given field is empty
 */
function checkField(fieldName) {
	var fieldValue = document.forms[formName].elements[fieldName].value;
	if (fieldValue == null || fieldValue.length == 0) {
		return false;
	}
	return true;
}

/*
 * Functionality:
 * 1. Throws error message and returns false if none of the hosts are selected for deletion.
 * 2. Returns false if the user doesnot give confirmation for deletion of selected hosts.
 */
function checkBeforeDelete() {
	var netFileHostsTiledViewName = "NetFileHostsTiledView";
	var netFileHostSelectCBName = "cbSelectHost";
	var netFileHostFieldName = "hostName";
	var netFileHostsCountField = formName + "." + "netFileHostsCount";
	var netFileHostsCount = document.forms[formName].elements[netFileHostsCountField].value;
	var noSelection = true;
	var selectedHosts = new Array();

	for (var i=0, j=0; i < netFileHostsCount; i++) {
		var checkBox = formName + "." + netFileHostsTiledViewName + "[" + i + "]." + netFileHostSelectCBName;
		var hostName = formName + "." + netFileHostsTiledViewName + "[" + i + "]." + netFileHostFieldName;
		if (document.forms[formName].elements[checkBox].checked) {
			noSelection = false;
			var selectedHostName = document.forms[formName].elements[hostName].value;
			selectedHosts[j++] = selectedHostName;
		}
	}
	if (noSelection) {
		alert(noHostSelection);
		return false;
	}

	var confirmMsg = confirmHostDelete + "\n\n";
	for (var i=0; i < selectedHosts.length; i++) {
		confirmMsg = confirmMsg + "\t"+ selectedHosts[i] + "\n";
	}
	var cf = confirm(confirmMsg);
	if (cf == true)
		return true;
	return false;
}

function saveToShareList() {
    var shareList = new Array();
    var length = document.forms[formName].elements[hostsharelist].options.length;
    for(var i = 0, j = 0; i < length; i++) {
        var val = document.forms[formName].elements[hostsharelist].options[i].value;
        if( val != null && val != "") {  
            shareList[j++] = val;
        } 
    }
    return shareList;
}

function saveShareList() {
    var hostType = getHostType();
    if(hostType == "WIN") {
        shareListWin = saveToShareList();
    } else if(hostType == "FTP") {
        shareListFtp = saveToShareList(); 
    } else if(hostType == "NFS") {
        shareListNfs = saveToShareList();
    } else if(hostType == "NETWARE") {
        shareListNetware = saveToShareList();
    }
}

function clearShareList() {
	for (var i = 0; i < document.forms[formName].elements[hostsharelist].length; i++) {
		var opt = document.forms[formName].elements[hostsharelist].options[i];
		document.forms[formName].elements[hostsharelist].options[i] = null;
  	    if (document.forms[formName].elements[hostsharelist].length > 0) {
			i--;
		}
	}
    document.forms[formName].elements[hostsharename].value = "";
    document.forms[formName].elements[hostsharepassword].value = "";
}

function restoreFromShareList(shareListName) {
    if( shareListName != null) {
	    for(var i=0; i < shareListName.length; i++) {
	        var shares = shareListName[i].split("\n");
	        var shareName = shares[0];
	        var shareValue = shareListName[i]; 
		    var opt = new Option(shareName, shareValue);
		    document.forms[formName].elements[hostsharelist].options[i] = opt;
	    }
	}
}

function restoreShareList() {
    clearShareList();
    var hostType = getHostType();
    if(hostType == "WIN") {
        restoreFromShareList(shareListWin);
    } else if(hostType == "FTP") {
       restoreFromShareList(shareListFtp);
    } else if(hostType == "NFS") {
       restoreFromShareList(shareListNfs);
    } else if(hostType == "NETWARE") {
       restoreFromShareList(shareListNetware);
    }
    addSizerToShareList();
    initShareList()
}

function addSizerToShareList() {
    var opt = new Option("---------------------------------------", "");
    var length = document.forms[formName].elements[hostsharelist].options.length; 
    document.forms[formName].elements[hostsharelist].options[length] = opt;
}

function getHostType() {
	var hostType = null;
	var hostTypeLength = document.forms[formName].elements[hosttype].options.length;
	for(var i = 0; i < hostTypeLength; i++) {
	    var opt = document.forms[formName].elements[hosttype].options[i];
	    if(opt.selected) {
	        break;
	    }
	}
	if(i < hostTypeLength) {
	    hostType = document.forms[formName].elements[hosttype].options[i].value;
	}
	return hostType;
}


function handleHostTypeChanged() {
	var hostType = getHostType();
	restoreShareList();
	/*
	var hostTypeLength = document.forms[formName].elements[hosttype].options.length;
	for(var i = 0; i < hostTypeLength; i++) {
	    var opt = document.forms[formName].elements[hosttype].options[i];
	    if(opt.selected) {
	        break;
	    }
	}
	if(i < hostTypeLength) {
	    hostType = document.forms[formName].elements[hosttype].options[i].value;
	}
	*/
	var isHostDomainDisabled = document.forms[formName].elements[hostdomain].disabled;
	if(isHostDomainDisabled == null || isHostDomainDisabled == "undefined") {
	    isHostDomainDisabled = true;
	}
	if(isHostDomainDisabled) {
	    if(hostType == "WIN") { 
		    hostDomainEnabled = true;
		    if(hostDomain != null) {
                document.forms[formName].elements[hostdomain].value = hostDomain;
            }		
		    document.forms[formName].elements[hostdomain].disabled = false;
		    document.forms[formName].elements[hostsharepassword].disabled = false;
		    editShareSelected();
	    }
	} else {
		hostDomainEnabled = false;
		hostDomain = document.forms[formName].elements[hostdomain].value;
		document.forms[formName].elements[hostdomain].value = "";
		document.forms[formName].elements[hostsharepassword].value = "";
		document.forms[formName].elements[hostdomain].disabled = true;
		document.forms[formName].elements[hostsharepassword].disabled = true;
	}
}

function loadInitURL(nameOfForm) {
	initURL = document.URL;
	var newInitURL = initURL.split("?");
	initURL = newInitURL[0];
	var lastIndex = initURL.lastIndexOf("/");
	initURL = initURL.slice(0,lastIndex);
	initURL = initURL + '/' + nameOfForm + '?';
}

function submitHandler(value, tabsFormName) {
	var tempURL = initURL;
	tempURL = tempURL + value + '=';
	tempURL = tempURL + '&' + document.forms[tabsFormName].elements['gx_charset'].name +'=';
	tempURL = tempURL + document.forms[tabsFormName].elements['gx_charset'].value;
	tempURL = tempURL + '&' + document.forms[tabsFormName].elements['jato.pageSession'].name +'=';
	tempURL = tempURL + document.forms[tabsFormName].elements['jato.pageSession'].value;
	document.forms[tabsFormName].action= tempURL;
	document.forms[tabsFormName].submit();
	return false;
}
		
