/*
 *  Copyright (c) 2000 Sun Microsystems.  All rights reserved.
 *  All rights reserved.
 * 
 *  Use of this software is governed by the terms of the license agreement 
 *  for the Sun ONE Compass Server between the parties.
 */


/* ------------------------------------------------------------------------ */


/*
 * CSIDCF configuration parameters
 * Copyright 2003 Sun Microsystems, Inc. All
 * rights reserved. Use of this product is subject
 * to license terms. Federal Acquisitions:
 * Commercial Software -- Government Users
 * Subject to Standard License Terms and
 * Conditions.
 *
 * Sun, Sun Microsystems, the Sun logo, and Sun ONE
 * are trademarks or registered trademarks of Sun Microsystems,
 * Inc. in the United States and other countries.
 */
#ifndef _RDM_CSIDCF_H_
#define _RDM_CSIDCF_H_

/* Load search.conf configuration file */
NSAPI_PUBLIC int CSIDCF_Init(char *csidcf);
NSAPI_PUBLIC void CSIDCF_Finish(void);

/* Set the default CSID */
NSAPI_PUBLIC int CSIDCF_SetDefault(char *csid);
NSAPI_PUBLIC const char *CSIDCF_GetDefault(void);

/* 
 *  Find a configuration parameter based on the given CSID.
 *  If the CSID is NULL, then it'll use the default if available.
 */
NSAPI_PUBLIC const char *CSIDCF_Findval(char *name, char *csid);

/* Search configuration parameters */

/* File defaults */
#define CSIDCF_CONFDIR		"config"
#define CSIDCF_CONF		"search.conf"
#ifdef XP_WIN32
#define CSIDCF_PATHSEP		"\\"
#else
#define CSIDCF_PATHSEP		"/"
#endif
#define CSID_DOT_CONF		CSIDCF_CONFDIR CSIDCF_PATHSEP CSIDCF_CONF

/* Database configurations */
#define CSIDCF_DBFN		"database-root"
#define CSIDCF_DBDIR 		"database-directory"
#define CSIDCF_DBNAME		"database-name"
#define CSIDCF_DBPARTS		"database-partitions"
#define CSIDCF_DBLODGIR         "database-logdir"
#define CSIDCF_DBSYNC		"database-sync-rate"
#define CSIDCF_DBMAX		"database-max-concurrent"

/* RDM configurations */
#define CSIDCF_SCHEMA		"schema-description"
#define CSIDCF_SERVER		"server-description"
#define CSIDCF_TAX		"taxonomy-description"
#define CSIDCF_TAX_REFRESH	"taxonomy-description-refresh-rate"
#define CSIDCF_QLFLUFF		"query-language-translation"

#define CSIDCF_MVCLASS		"multiple-classifications"

/* Sage configurations */
#define CSIDCF_NSIRTNAME  	"taxonomy-database-name"
#define CSIDCF_NSIRCNAME  	"search-collection-name"
#define CSIDCF_NSIRMAXBATCH  	"search-max-index-batch"
#define CSIDCF_NSIRMAXFVAL      "search-max-field-value"
#define CSIDCF_NSIRCF  		"search-config"

/* Log files */
#define CSIDCF_STATLOG 		"statistics-log"

/* Misc */
#define CSIDCF_TMPDIR		"tmpdir"
#define CSIDCF_BINDIR		"bindir"
#define CSIDCF_LIBDIR		"libdir"
#define CSIDCF_LOGFN		"logfile"
#define CSIDCF_DEBUG_LOGFN	"debug-logfile"
#define CSIDCF_DEBUG_LOGLV	"debug-loglevel"
#define CSIDCF_ALIASFN		"alias-config"
#define CSIDCF_EXCLUDE_GV	"reports-exclude-gv-queries"

/* admin look and feel */
#define CSIDCF_SAVE_APPLY       "backup-auto-save-n-apply"
#define CSIDCF_ADMIN_LAYOUT	"admin-screen-layout"
#define CSIDCF_CHECK_DNS	"filters-check-dns"
#define CSIDCF_CHECK_302	"filters-check-redirect"
#define CSIDCF_CHECK_VIRTUAL	"filters-check-virtual"
#define CSIDCF_ROBOT_REFRESH	"robot-refresh"
#define CSIDCF_ROBOT_LOGS	"rlog-max-logs"

/* templates */
#define CSIDCF_TEMPL_DEFAULT	"template-default"
#define CSIDCF_TEMPL_DIR	"template-dir"
#define CSIDCF_TEMPL_REFRESH	"template-refresh-rate"

#endif /* _RDM_CSIDCF_H_ */
