/*
 *  Copyright (c) 2000 Sun Microsystems.  All rights reserved.
 *  All rights reserved.
 * 
 *  Use of this software is governed by the terms of the license agreement 
 *  for the Sun ONE Compass Server between the parties.
 */


/* ------------------------------------------------------------------------ */


/*
 * Copyright 2003 Sun Microsystems, Inc. All
 * rights reserved. Use of this product is subject
 * to license terms. Federal Acquisitions:
 * Commercial Software -- Government Users
 * Subject to Standard License Terms and
 * Conditions.
 *
 * Sun, Sun Microsystems, the Sun logo, and Sun ONE
 * are trademarks or registered trademarks of Sun Microsystems,
 * Inc. in the United States and other countries.
 */
#ifndef _CSMEM_H_
#define _CSMEM_H_

#include "base/systems.h"
#include <stdlib.h>
#include <malloc.h>

/* Used in some places as a length limit on error messages */
#define MAGNUS_ERROR_LEN 8192

/* Carraige return and line feed */
#define CR 13
#define LF 10
#ifdef XP_WIN32
#define ENDLINE "\r\n"
#else
#define ENDLINE "\n"
#endif


#define MALLOC(size) malloc(size)
 
#define CALLOC(nelem, size) calloc(nelem, size)
 
#define REALLOC(ptr, size) realloc(ptr, size)
 
#define FREE(ptr) free(ptr)
 
#define STRDUP(ptr) strdup(ptr)

/* a replacement for PR_GetErrorString, caller must free return */
char *CS_GetErrorString(void);

#endif
