/* 
 *  Example 3 - SOIF Stream Parsing/Printing using attribute filtering
 *
 * Copyright 2003 Sun Microsystems, Inc. All
 * rights reserved. Use of this product is subject
 * to license terms. Federal Acquisitions:
 * Commercial Software -- Government Users
 * Subject to Standard License Terms and
 * Conditions.
 *
 * Sun, Sun Microsystems, the Sun logo, and Sun ONE
 * are trademarks or registered trademarks of Sun Microsystems,
 * Inc. in the United States and other countries.
 */
#include <stdio.h>
#include <stdlib.h>

#include "soif.h"

char *allowed_attributes[] = {	/* allow these attrs, but filter out the rest */
	"author",
	"title",
	"description",
	"content-type",
	"content-length",
	NULL
};

int main(int argc, char *argv[])
{
	SOIFStream *in, *out;
	SOIF *s;
	char **p;

	/* Open a SOIFStream to parse a SOIF stream on stdin */
	in = SOIF_ParseInitFile(stdin);

	/* Open a SOIFStream to print a SOIF stream on stdout, attach filter */
	if ((out = SOIF_PrintInitFile(stdout)))
		SOIFStream_SetAllowed(out, allowed_attributes);

	while (!SOIFStream_IsEOS(in)) {		/* until the End-Of-Stream */
		if (!(s = (*in->parse)(in)))	/* Parse the next SOIF */
			continue;		/* Invalid SOIF */

		/* Print URL and Attribute Count for each SOIF */
		printf("URL = %s\n", s->url);
		printf("# of Attributes = %d\n", SOIF_GetAttributeCount(s));

		/* Print to SOIFStream through filter */
		(*out->print)(out, s);

		SOIF_Free(s);
	}

	/* Close the SOIFStream */
	SOIFStream_Finish(in);
	SOIFStream_Finish(out);
	exit(0);
}
