/* 
 *  Example 2 - SOIF Stream Parsing using attribute filtering
 *
 * Copyright 2003 Sun Microsystems, Inc. All
 * rights reserved. Use of this product is subject
 * to license terms. Federal Acquisitions:
 * Commercial Software -- Government Users
 * Subject to Standard License Terms and
 * Conditions.
 *
 * Sun, Sun Microsystems, the Sun logo, and Sun ONE
 * are trademarks or registered trademarks of Sun Microsystems,
 * Inc. in the United States and other countries.
 */
#include <stdio.h>
#include <stdlib.h>

#include "soif.h"

char *allowed_attributes[] = {	/* allow these attrs, but filter out the rest */
	"author",
	"title",
	"description",
	"content-type",
	"content-length",
	NULL
};

int main(int argc, char *argv[])
{
	SOIFStream *ss;
	SOIF *s;
	char **p;

	/* Open a SOIFStream to parse a SOIF stream on stdin */
	if ((ss = SOIF_ParseInitFile(stdin)))
		SOIFStream_SetAllowed(ss, allowed_attributes);

	while (!SOIFStream_IsEOS(ss)) {		/* until the End-Of-Stream */
		if (!(s = (*ss->parse)(ss)))	/* Parse the next SOIF */
			continue;		/* Invalid SOIF */

		/* Print URL and Attribute Count for each SOIF */
		printf("URL = %s\n", s->url);
		printf("# of Attributes = %d\n", SOIF_GetAttributeCount(s));

		/* Print each Attribute = Value pair for primary values only */
		for (p = (*s->get_attributes)(s); p && *p; p++) 
			printf("%s = '%s'\n", *p, (*s->findval)(s, *p));

		SOIF_Free(s);
	}

	/* Close the SOIFStream */
	SOIFStream_Finish(ss);
	exit(0);
}
