/* 
 *  Example 1 - Simple SOIF Stream Parsing 
 *
 * Copyright 2003 Sun Microsystems, Inc. All
 * rights reserved. Use of this product is subject
 * to license terms. Federal Acquisitions:
 * Commercial Software -- Government Users
 * Subject to Standard License Terms and
 * Conditions.
 *
 * Sun, Sun Microsystems, the Sun logo, and Sun ONE
 * are trademarks or registered trademarks of Sun Microsystems,
 * Inc. in the United States and other countries.
 */
#include <stdio.h>
#include <stdlib.h>

#include "soif.h"

int main(int argc, char *argv[])
{
	SOIFStream *ss;
	SOIF *s;

	/* Open a SOIFStream to parse a SOIF stream on stdin */
	ss = SOIF_ParseInitFile(stdin);

	while (!SOIFStream_IsEOS(ss)) {		/* until the End-Of-Stream */
		if (!(s = (*ss->parse)(ss)))	/* Parse the next SOIF */
			continue;		/* Invalid SOIF */

		/* Print URL and Attribute Count for each SOIF */
		printf("URL = %s\n", s->url);
		printf("# of Attributes = %d\n", SOIF_GetAttributeCount(s));

		SOIF_Free(s);
	}

	/* Close the SOIFStream */
	SOIFStream_Finish(ss);
	exit(0);
}
